/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.Version;
import org.infinispan.protostream.annotations.ProtoSchemaBuilderException;
import org.infinispan.protostream.annotations.impl.BaseProtoSchemaGenerator;
import org.infinispan.protostream.annotations.impl.RuntimeProtoSchemaGenerator;
import org.infinispan.protostream.annotations.impl.types.ReflectionClassFactory;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.impl.Log;
import protostream.org.apache.commons.cli.CommandLine;
import protostream.org.apache.commons.cli.GnuParser;
import protostream.org.apache.commons.cli.HelpFormatter;
import protostream.org.apache.commons.cli.Option;
import protostream.org.apache.commons.cli.Options;
import protostream.org.apache.commons.cli.ParseException;

@Deprecated
public final class ProtoSchemaBuilder {
    private static final Log log = Log.LogFactory.getLog(ProtoSchemaBuilder.class);
    public static final String DEFAULT_GENERATED_SCHEMA_NAME = "generated.proto";
    public static final String FILE_OPT = "f";
    public static final String FILE_LONG_OPT = "file";
    public static final String PACKAGE_OPT = "p";
    public static final String PACKAGE_LONG_OPT = "package";
    public static final String HELP_OPT = "h";
    public static final String HELP_LONG_OPT = "help";
    public static final String MARSHALLER_OPT = "m";
    public static final String MARSHALLER_LONG_OPT = "marshaller";
    public static final String SCHEMA_OPT = "s";
    public static final String SCHEMA_LONG_OPT = "schema";
    @Deprecated
    public static boolean generateSchemaDebugComments = false;
    private String fileName;
    private String packageName;
    private String generator;
    private final Set<Class<?>> classes = new LinkedHashSet();
    private boolean autoImportClasses = true;

    public static void main(String[] args) throws Exception {
        String[] marshallers;
        CommandLine cmd = ProtoSchemaBuilder.parseCommandLine(args);
        if (cmd == null) {
            return;
        }
        String packageName = cmd.getOptionValue(PACKAGE_LONG_OPT);
        Configuration config = Configuration.builder().build();
        SerializationContext ctx = ProtobufUtil.newSerializationContext(config);
        Properties schemas = cmd.getOptionProperties(SCHEMA_LONG_OPT);
        if (schemas != null) {
            for (String string : schemas.stringPropertyNames()) {
                String file = schemas.getProperty(string);
                FileInputStream in = new FileInputStream(file);
                Throwable throwable = null;
                try {
                    ctx.registerProtoFiles(new FileDescriptorSource().addProtoFile(string, in));
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
        if ((marshallers = cmd.getOptionValues(MARSHALLER_LONG_OPT)) != null) {
            for (String string : marshallers) {
                BaseMarshaller bm = (BaseMarshaller)Class.forName(string).newInstance();
                ctx.registerMarshaller(bm);
            }
        }
        File file = cmd.hasOption(FILE_LONG_OPT) ? new File(cmd.getOptionValue(FILE_LONG_OPT)) : null;
        String fileName = file == null ? DEFAULT_GENERATED_SCHEMA_NAME : file.getName();
        ProtoSchemaBuilder protoSchemaBuilder = new ProtoSchemaBuilder().fileName(fileName).packageName(packageName);
        for (String className : cmd.getArgs()) {
            protoSchemaBuilder.addClass(Class.forName(className));
        }
        String string = protoSchemaBuilder.build(ctx);
        if (file != null) {
            try (PrintStream out = new PrintStream(new FileOutputStream(file));){
                out.print(string);
                out.flush();
            }
        } else {
            System.out.print(string);
        }
    }

    private static CommandLine parseCommandLine(String[] args) throws ParseException {
        Option h = new Option(HELP_OPT, HELP_LONG_OPT, false, "Print usage information and exit immediately");
        Option f = new Option(FILE_OPT, FILE_LONG_OPT, true, "Output *.proto schema file name (required)");
        Option p = new Option(PACKAGE_OPT, PACKAGE_LONG_OPT, true, "The Protobuf package name of the generated schema (optional)");
        Option m = new Option(MARSHALLER_OPT, MARSHALLER_LONG_OPT, true, "Register an existing marshaller class to be available for 'includes' (optional, multiple)");
        Option s = new Option(SCHEMA_OPT, SCHEMA_LONG_OPT, true, "Register an existing Protobuf schema to be available for 'includes' (optional, multiple)");
        s.setArgs(2);
        s.setValueSeparator('=');
        Options options = new Options();
        options.addOption(f);
        options.addOption(p);
        options.addOption(h);
        options.addOption(m);
        options.addOption(s);
        GnuParser parser = new GnuParser();
        CommandLine cmd = parser.parse(options, args);
        if (cmd.hasOption(HELP_OPT)) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.setSyntaxPrefix("ProtoStream " + Version.getVersion() + " " + ProtoSchemaBuilder.class.getSimpleName());
            formatter.printHelp(200, " usage: java " + ProtoSchemaBuilder.class.getName() + " [options] <list of fully qualified class names to process>", "Options: ", options, "The list of class names is separated by whitespace.");
            return null;
        }
        return cmd;
    }

    public ProtoSchemaBuilder fileName(String fileName) {
        if (fileName == null || fileName.trim().isEmpty()) {
            throw new IllegalArgumentException("fileName cannot be null or empty");
        }
        if (!fileName.endsWith(".proto")) {
            log.warnf("File name '%s' should end with '.proto'", fileName);
        }
        this.fileName = fileName;
        return this;
    }

    public ProtoSchemaBuilder packageName(String packageName) {
        if (packageName != null && packageName.trim().isEmpty()) {
            throw new IllegalArgumentException("packageName cannot be empty");
        }
        this.packageName = packageName;
        return this;
    }

    public ProtoSchemaBuilder generator(String generator) {
        this.generator = generator;
        return this;
    }

    public ProtoSchemaBuilder addClass(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("class argument cannot be null");
        }
        this.classes.add(clazz);
        return this;
    }

    public ProtoSchemaBuilder addClasses(Class<?> ... classes) {
        if (classes == null || classes.length == 0) {
            throw new IllegalArgumentException("classes argument cannot be null or empty");
        }
        Collections.addAll(this.classes, classes);
        return this;
    }

    public ProtoSchemaBuilder autoImportClasses(boolean autoImportClasses) {
        this.autoImportClasses = autoImportClasses;
        return this;
    }

    public String build(SerializationContext serializationContext) throws ProtoSchemaBuilderException, IOException {
        return this.build(serializationContext, null);
    }

    public String build(SerializationContext serializationContext, ClassLoader classLoader) throws ProtoSchemaBuilderException, IOException {
        ReflectionClassFactory typeFactory = new ReflectionClassFactory();
        Set xclasses = this.classes.stream().map(typeFactory::fromClass).collect(Collectors.toCollection(LinkedHashSet::new));
        BaseProtoSchemaGenerator.generateSchemaDebugComments = generateSchemaDebugComments;
        return new RuntimeProtoSchemaGenerator(typeFactory, serializationContext, this.generator, this.fileName, this.packageName, xclasses, this.autoImportClasses, classLoader).generateAndRegister();
    }
}

