/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.ee.concurrent.ManagedExecutorWithHungThreads;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class ManagedExecutorTerminateHungTasksOperation<T> {
    public static final String NAME = "terminate-hung-tasks";
    private final RuntimeCapability capability;
    private final SimpleOperationDefinition operationDefinition;
    private final ExecutorProvider<T> executorProvider;

    ManagedExecutorTerminateHungTasksOperation(RuntimeCapability capability, ResourceDescriptionResolver resolver, ExecutorProvider<T> executorProvider) {
        this.capability = capability;
        this.operationDefinition = new SimpleOperationDefinitionBuilder(NAME, resolver).setRuntimeOnly().build();
        this.executorProvider = executorProvider;
    }

    void registerOperation(ManagementResourceRegistration resourceRegistration) {
        if (resourceRegistration.getProcessType().isServer()) {
            resourceRegistration.registerOperationHandler((OperationDefinition)this.operationDefinition, (OperationStepHandler)new AbstractRuntimeOnlyHandler(){

                protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
                    if (context.getRunningMode() == RunningMode.NORMAL) {
                        ServiceName serviceName = ManagedExecutorTerminateHungTasksOperation.this.capability.getCapabilityServiceName(context.getCurrentAddress());
                        ServiceController controller = context.getServiceRegistry(false).getService(serviceName);
                        if (controller == null) {
                            throw EeLogger.ROOT_LOGGER.executorServiceNotFound(serviceName);
                        }
                        Service service = controller.getService();
                        ManagedExecutorWithHungThreads executor = ManagedExecutorTerminateHungTasksOperation.this.executorProvider.getExecutor(service);
                        executor.terminateHungTasks();
                    }
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
            });
        }
    }

    static interface ExecutorProvider<T> {
        public ManagedExecutorWithHungThreads getExecutor(T var1);
    }
}

