/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import org.infinispan.protostream.impl.WireFormat;
import org.jboss.as.network.ClientMapping;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.common.net.Inet;

public class ClientMappingMarshaller
implements ProtoStreamMarshaller<ClientMapping> {
    private static final InetAddress DEFAULT_SOURCE_ADDRESS = InetAddress.getLoopbackAddress() instanceof Inet4Address ? Inet.INET4_ANY : Inet.INET6_ANY;
    private static final int DEFAULT_SOURCE_MASK = 0;
    private static final String DEFAULT_DESTINATION_ADDRESS = Inet.toURLString((InetAddress)InetAddress.getLoopbackAddress(), (boolean)true);
    private static final int DEFAULT_DESINATION_PORT = 8080;
    private static final int SOURCE_ADDRESS_INDEX = 1;
    private static final int SOURCE_MASK_INDEX = 2;
    private static final int DESTINATION_ADDRESS_INDEX = 3;
    private static final int DESTINATION_PORT_INDEX = 4;

    public ClientMapping readFrom(ProtoStreamReader reader) throws IOException {
        InetAddress sourceAddress = DEFAULT_SOURCE_ADDRESS;
        int sourceMask = 0;
        String destinationAddress = DEFAULT_DESTINATION_ADDRESS;
        int destinationPort = 8080;
        boolean reading = true;
        block6: while (reading) {
            int tag = reader.readTag();
            switch (WireFormat.getTagFieldNumber((int)tag)) {
                case 1: {
                    sourceAddress = (InetAddress)reader.readObject(InetAddress.class);
                    continue block6;
                }
                case 2: {
                    sourceMask = reader.readUInt32();
                    continue block6;
                }
                case 3: {
                    destinationAddress = reader.readString();
                    continue block6;
                }
                case 4: {
                    destinationPort = reader.readUInt32();
                    continue block6;
                }
            }
            reading = tag != 0 && reader.skipField(tag);
        }
        return new ClientMapping(sourceAddress, sourceMask, destinationAddress, destinationPort);
    }

    public void writeTo(ProtoStreamWriter writer, ClientMapping mapping) throws IOException {
        int destinationPort;
        String destinationAddress;
        int sourceNetworkMask;
        InetAddress address = mapping.getSourceNetworkAddress();
        if (!address.equals(DEFAULT_SOURCE_ADDRESS)) {
            writer.writeObject(1, (Object)address);
        }
        if ((sourceNetworkMask = mapping.getSourceNetworkMaskBits()) != 0) {
            writer.writeUInt32(2, sourceNetworkMask);
        }
        if (!(destinationAddress = mapping.getDestinationAddress()).equals(DEFAULT_DESTINATION_ADDRESS)) {
            writer.writeString(3, mapping.getDestinationAddress());
        }
        if ((destinationPort = mapping.getDestinationPort()) != 8080) {
            writer.writeUInt32(4, destinationPort);
        }
    }

    public Class<? extends ClientMapping> getJavaClass() {
        return ClientMapping.class;
    }
}

