/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.filters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.Logging;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.dmr.ModelNode;

public class Filters {
    public static final String ACCEPT = "accept";
    public static final String ALL = "all";
    public static final String ANY = "any";
    public static final String DENY = "deny";
    public static final String LEVELS = "levels";
    public static final String LEVEL_CHANGE = "levelChange";
    public static final String LEVEL_RANGE = "levelRange";
    public static final String MATCH = "match";
    public static final String NOT = "not";
    public static final String SUBSTITUTE = "substitute";
    public static final String SUBSTITUTE_ALL = "substituteAll";

    public static String filterToFilterSpec(ModelNode value) throws OperationFailedException {
        if (value.isDefined()) {
            StringBuilder result = new StringBuilder();
            Filters.filterToFilterSpec(value, result, false);
            if (result.length() == 0) {
                String name = value.hasDefined(CommonAttributes.FILTER.getName()) ? value.get(CommonAttributes.FILTER.getName()).asString() : value.asString();
                throw Logging.createOperationFailure(LoggingLogger.ROOT_LOGGER.invalidFilter(name));
            }
            return result.toString();
        }
        return "";
    }

    public static ModelNode filterSpecToFilter(String value) {
        ModelNode filter = new ModelNode(CommonAttributes.FILTER.getName()).setEmptyObject();
        Iterator<String> iterator = Filters.tokens(value).iterator();
        Filters.parseFilterExpression(iterator, filter);
        return filter;
    }

    public static Collection<String> getCustomFilterNames(String filterSpec) {
        HashSet<String> result = new HashSet<String>();
        if (filterSpec != null) {
            result.addAll(Filters.parseFilterExpression(filterSpec));
        }
        return result;
    }

    private static Collection<String> parseFilterExpression(String value) {
        return Filters.parseFilterExpression(Filters.tokens(value).iterator(), new ModelNode(), true, false);
    }

    private static void parseFilterExpression(Iterator<String> iterator, ModelNode model) {
        Filters.parseFilterExpression(iterator, model, true, true);
    }

    private static Collection<String> parseFilterExpression(Iterator<String> iterator, ModelNode model, boolean outermost, boolean forFilter) {
        ArrayList<String> result = new ArrayList<String>();
        if (!iterator.hasNext()) {
            if (outermost) {
                model.setEmptyObject();
                return Collections.emptyList();
            }
            throw LoggingLogger.ROOT_LOGGER.unexpectedEnd();
        }
        String token = iterator.next();
        if (ACCEPT.equals(token)) {
            Filters.set((AttributeDefinition)CommonAttributes.ACCEPT, model, true);
        } else if (DENY.equals(token)) {
            Filters.set((AttributeDefinition)CommonAttributes.DENY, model, true);
        } else if (NOT.equals(token)) {
            Filters.expect("(", iterator);
            result.addAll(Filters.parseFilterExpression(iterator, model.get(CommonAttributes.NOT.getName()), false, forFilter));
            Filters.expect(")", iterator);
        } else if (ALL.equals(token)) {
            Filters.expect("(", iterator);
            do {
                ModelNode m = model.get(CommonAttributes.ALL.getName());
                result.addAll(Filters.parseFilterExpression(iterator, m, false, forFilter));
            } while (Filters.expect(",", ")", iterator));
        } else if (ANY.equals(token)) {
            Filters.expect("(", iterator);
            do {
                ModelNode m = model.get(CommonAttributes.ANY.getName());
                result.addAll(Filters.parseFilterExpression(iterator, m, false, forFilter));
            } while (Filters.expect(",", ")", iterator));
        } else if (LEVEL_CHANGE.equals(token)) {
            Filters.expect("(", iterator);
            String levelName = Filters.expectName(iterator);
            Filters.set((AttributeDefinition)CommonAttributes.CHANGE_LEVEL, model, levelName);
            Filters.expect(")", iterator);
        } else if (LEVELS.equals(token)) {
            Filters.expect("(", iterator);
            HashSet<String> levels = new HashSet<String>();
            do {
                levels.add(Filters.expectName(iterator));
            } while (Filters.expect(",", ")", iterator));
            if (levels.iterator().hasNext()) {
                Filters.set((AttributeDefinition)CommonAttributes.LEVEL, model, (String)levels.iterator().next());
            }
        } else if (LEVEL_RANGE.equals(token)) {
            ModelNode levelRange = model.get(CommonAttributes.LEVEL_RANGE_LEGACY.getName());
            boolean minInclusive = Filters.expect("[", "(", iterator);
            if (minInclusive) {
                Filters.set((AttributeDefinition)CommonAttributes.MIN_INCLUSIVE, levelRange, minInclusive);
            }
            String minLevel = Filters.expectName(iterator);
            Filters.set((AttributeDefinition)CommonAttributes.MIN_LEVEL, levelRange, minLevel);
            Filters.expect(",", iterator);
            String maxLevel = Filters.expectName(iterator);
            Filters.set((AttributeDefinition)CommonAttributes.MAX_LEVEL, levelRange, maxLevel);
            boolean maxInclusive = Filters.expect("]", ")", iterator);
            if (maxInclusive) {
                Filters.set((AttributeDefinition)CommonAttributes.MAX_INCLUSIVE, levelRange, maxInclusive);
            }
        } else if (MATCH.equals(token)) {
            Filters.expect("(", iterator);
            String pattern = Filters.expectString(iterator);
            Filters.set((AttributeDefinition)CommonAttributes.MATCH, model, pattern);
            Filters.expect(")", iterator);
        } else if (SUBSTITUTE.equals(token)) {
            ModelNode substitute = model.get(CommonAttributes.REPLACE.getName());
            substitute.get(CommonAttributes.REPLACE_ALL.getName()).set(false);
            Filters.expect("(", iterator);
            String pattern = Filters.expectString(iterator);
            Filters.set((AttributeDefinition)CommonAttributes.FILTER_PATTERN, substitute, pattern);
            Filters.expect(",", iterator);
            String replacement = Filters.expectString(iterator);
            Filters.set((AttributeDefinition)CommonAttributes.REPLACEMENT, substitute, replacement);
            Filters.expect(")", iterator);
        } else if (SUBSTITUTE_ALL.equals(token)) {
            ModelNode substitute = model.get(CommonAttributes.REPLACE.getName());
            substitute.get(CommonAttributes.REPLACE_ALL.getName()).set(true);
            Filters.expect("(", iterator);
            String pattern = Filters.expectString(iterator);
            Filters.set((AttributeDefinition)CommonAttributes.FILTER_PATTERN, substitute, pattern);
            Filters.expect(",", iterator);
            String replacement = Filters.expectString(iterator);
            Filters.set((AttributeDefinition)CommonAttributes.REPLACEMENT, substitute, replacement);
            Filters.expect(")", iterator);
        } else {
            if (forFilter) {
                LoggingLogger.ROOT_LOGGER.debugf("Only known filters are supported on the filter attribute. Ignoring filter %s.", token);
            }
            result.add(token);
        }
        return result;
    }

    private static String expectName(Iterator<String> iterator) {
        String next;
        if (iterator.hasNext() && Character.isJavaIdentifierStart((next = iterator.next()).codePointAt(0))) {
            return next;
        }
        throw LoggingLogger.ROOT_LOGGER.expectedIdentifier();
    }

    private static String expectString(Iterator<String> iterator) {
        String next;
        if (iterator.hasNext() && (next = iterator.next()).codePointAt(0) == 34) {
            return next.substring(1);
        }
        throw LoggingLogger.ROOT_LOGGER.expectedString();
    }

    private static boolean expect(String trueToken, String falseToken, Iterator<String> iterator) {
        boolean result;
        String next;
        boolean hasNext = iterator.hasNext();
        String string = next = hasNext ? iterator.next() : null;
        if (!hasNext || !(result = trueToken.equals(next)) && !falseToken.equals(next)) {
            throw LoggingLogger.ROOT_LOGGER.expected(trueToken, falseToken);
        }
        return result;
    }

    private static void expect(String token, Iterator<String> iterator) {
        if (!iterator.hasNext() || !token.equals(iterator.next())) {
            throw LoggingLogger.ROOT_LOGGER.expected(token);
        }
    }

    private static void set(AttributeDefinition attribute, ModelNode model, String value) {
        Filters.set(attribute.getName(), model, value);
    }

    private static void set(AttributeDefinition attribute, ModelNode model, boolean value) {
        Filters.set(attribute.getName(), model, value);
    }

    private static void set(String name, ModelNode model, String value) {
        model.get(name).set(value);
    }

    private static void set(String name, ModelNode model, boolean value) {
        model.get(name).set(value);
    }

    private static List<String> tokens(String source) {
        ArrayList<String> tokens = new ArrayList<String>();
        int length = source.length();
        int idx = 0;
        while (idx < length) {
            int start;
            block16: {
                int ch = source.codePointAt(idx);
                if (Character.isWhitespace(ch)) {
                    ch = source.codePointAt(idx);
                    idx = source.offsetByCodePoints(idx, 1);
                    continue;
                }
                if (Character.isJavaIdentifierStart(ch)) {
                    start = idx;
                    while ((idx = source.offsetByCodePoints(idx, 1)) < length && Character.isJavaIdentifierPart(ch = source.codePointAt(idx))) {
                    }
                    tokens.add(source.substring(start, idx));
                    continue;
                }
                if (ch != 34) break block16;
                StringBuilder b = new StringBuilder();
                b.append('\"');
                idx = source.offsetByCodePoints(idx, 1);
                while (idx < length && (ch = source.codePointAt(idx)) != 34) {
                    block18: {
                        block17: {
                            ch = source.codePointAt(idx);
                            if (ch != 92) break block17;
                            if ((idx = source.offsetByCodePoints(idx, 1)) == length) {
                                throw LoggingLogger.ROOT_LOGGER.truncatedFilterExpression();
                            }
                            ch = source.codePointAt(idx);
                            switch (ch) {
                                case 92: {
                                    b.append('\\');
                                    break block18;
                                }
                                case 39: {
                                    b.append('\'');
                                    break block18;
                                }
                                case 34: {
                                    b.append('\"');
                                    break block18;
                                }
                                case 98: {
                                    b.append('\b');
                                    break block18;
                                }
                                case 102: {
                                    b.append('\f');
                                    break block18;
                                }
                                case 110: {
                                    b.append('\n');
                                    break block18;
                                }
                                case 114: {
                                    b.append('\r');
                                    break block18;
                                }
                                case 116: {
                                    b.append('\t');
                                    break block18;
                                }
                                default: {
                                    throw LoggingLogger.ROOT_LOGGER.invalidEscapeFoundInFilterExpression();
                                }
                            }
                        }
                        b.appendCodePoint(ch);
                    }
                    idx = source.offsetByCodePoints(idx, 1);
                }
                idx = source.offsetByCodePoints(idx, 1);
                tokens.add(b.toString());
                continue;
            }
            start = idx;
            idx = source.offsetByCodePoints(idx, 1);
            tokens.add(source.substring(start, idx));
        }
        return tokens;
    }

    private static void filterToFilterSpec(ModelNode value, StringBuilder result, boolean prefixComma) throws OperationFailedException {
        if (!value.isDefined()) {
            return;
        }
        if (value.has(CommonAttributes.ACCEPT.getName())) {
            if (value.get(CommonAttributes.ACCEPT.getName()).isDefined()) {
                if (prefixComma) {
                    result.append(',');
                }
                result.append(ACCEPT);
            }
        } else if (value.has(CommonAttributes.ALL.getName())) {
            ModelNode allValue = value.get(CommonAttributes.ALL.getName());
            if (allValue.isDefined()) {
                if (prefixComma) {
                    result.append(',');
                }
                result.append(ALL).append('(');
                boolean addComma = false;
                for (ModelNode filterValue : allValue.asList()) {
                    int currentLen = result.length();
                    Filters.filterToFilterSpec(filterValue, result, addComma);
                    if (result.length() <= currentLen) continue;
                    addComma = true;
                }
                result.append(")");
            }
        } else if (value.has(CommonAttributes.ANY.getName())) {
            ModelNode anyValue = value.get(CommonAttributes.ANY.getName());
            if (anyValue.isDefined()) {
                if (prefixComma) {
                    result.append(',');
                }
                result.append(ANY).append('(');
                boolean addComma = false;
                for (ModelNode filterValue : anyValue.asList()) {
                    int currentLen = result.length();
                    Filters.filterToFilterSpec(filterValue, result, addComma);
                    if (result.length() <= currentLen) continue;
                    addComma = true;
                }
                result.append(")");
            }
        } else if (value.has(CommonAttributes.CHANGE_LEVEL.getName())) {
            ModelNode changeLevelValue = value.get(CommonAttributes.CHANGE_LEVEL.getName());
            if (changeLevelValue.isDefined()) {
                if (prefixComma) {
                    result.append(',');
                }
                result.append(LEVEL_CHANGE).append('(').append(changeLevelValue.asString()).append(')');
            }
        } else if (value.has(CommonAttributes.DENY.getName())) {
            if (value.get(CommonAttributes.DENY.getName()).isDefined()) {
                if (prefixComma) {
                    result.append(',');
                }
                result.append(DENY);
            }
        } else if (value.has(CommonAttributes.LEVEL.getName())) {
            ModelNode levelValue = value.get(CommonAttributes.LEVEL.getName());
            if (levelValue.isDefined()) {
                if (prefixComma) {
                    result.append(',');
                }
                result.append(LEVELS).append('(').append(levelValue.asString()).append(')');
            }
        } else if (value.has(CommonAttributes.LEVEL_RANGE_LEGACY.getName())) {
            ModelNode levelRangeValue = value.get(CommonAttributes.LEVEL_RANGE_LEGACY.getName());
            if (levelRangeValue.isDefined()) {
                boolean maxInclusive;
                if (prefixComma) {
                    result.append(',');
                }
                ModelNode levelRange = value.get(CommonAttributes.LEVEL_RANGE_LEGACY.getName());
                result.append(LEVEL_RANGE);
                boolean minInclusive = levelRange.hasDefined(CommonAttributes.MIN_INCLUSIVE.getName()) && levelRange.get(CommonAttributes.MIN_INCLUSIVE.getName()).asBoolean();
                boolean bl = maxInclusive = levelRange.hasDefined(CommonAttributes.MAX_INCLUSIVE.getName()) && levelRange.get(CommonAttributes.MAX_INCLUSIVE.getName()).asBoolean();
                if (minInclusive) {
                    result.append("[");
                } else {
                    result.append("(");
                }
                result.append(levelRange.get(CommonAttributes.MIN_LEVEL.getName()).asString()).append(",");
                result.append(levelRange.get(CommonAttributes.MAX_LEVEL.getName()).asString());
                if (maxInclusive) {
                    result.append("]");
                } else {
                    result.append(")");
                }
            }
        } else if (value.has(CommonAttributes.MATCH.getName())) {
            ModelNode matchValue = value.get(CommonAttributes.MATCH.getName());
            if (matchValue.isDefined()) {
                if (prefixComma) {
                    result.append(',');
                }
                result.append(MATCH).append('(').append(Filters.escapeString(matchValue)).append(')');
            }
        } else if (value.has(CommonAttributes.NOT.getName())) {
            ModelNode notValue = value.get(CommonAttributes.NOT.getName());
            if (notValue.isDefined()) {
                if (prefixComma) {
                    result.append(',');
                }
                result.append(NOT).append('(');
                Filters.filterToFilterSpec(notValue, result, false);
                result.append(')');
            }
        } else if (value.has(CommonAttributes.REPLACE.getName())) {
            ModelNode replaceValue = value.get(CommonAttributes.REPLACE.getName());
            if (replaceValue.isDefined()) {
                boolean replaceAll;
                if (prefixComma) {
                    result.append(',');
                }
                if (replaceAll = replaceValue.hasDefined(CommonAttributes.REPLACE_ALL.getName()) ? replaceValue.get(CommonAttributes.REPLACE_ALL.getName()).asBoolean() : CommonAttributes.REPLACE_ALL.getDefaultValue().asBoolean()) {
                    result.append(SUBSTITUTE_ALL);
                } else {
                    result.append(SUBSTITUTE);
                }
                result.append("(").append(Filters.escapeString((AttributeDefinition)CommonAttributes.FILTER_PATTERN, replaceValue)).append(",").append(Filters.escapeString((AttributeDefinition)CommonAttributes.REPLACEMENT, replaceValue)).append(")");
            }
        } else {
            String name = value.hasDefined(CommonAttributes.FILTER.getName()) ? value.get(CommonAttributes.FILTER.getName()).asString() : value.asString();
            throw Logging.createOperationFailure(LoggingLogger.ROOT_LOGGER.invalidFilter(name));
        }
    }

    private static String escapeString(AttributeDefinition attribute, ModelNode value) {
        return Filters.escapeString(value.get(attribute.getName()));
    }

    private static String escapeString(ModelNode value) {
        return String.format("\"%s\"", value.asString().replace("\\", "\\\\"));
    }
}

