/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.idm.model;

import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RestartParentResourceRemoveHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.idm.model.PartitionManagerAddHandler;
import org.wildfly.extension.picketlink.idm.model.PartitionManagerRemoveHandler;
import org.wildfly.extension.picketlink.idm.service.PartitionManagerService;
import org.wildfly.extension.picketlink.logging.PicketLinkLogger;

public class IdentityConfigurationRemoveStepHandler
extends RestartParentResourceRemoveHandler {
    static final IdentityConfigurationRemoveStepHandler INSTANCE = new IdentityConfigurationRemoveStepHandler();

    private IdentityConfigurationRemoveStepHandler() {
        super(ModelElement.PARTITION_MANAGER.getName());
    }

    protected void updateModel(OperationContext context, ModelNode operation) throws OperationFailedException {
        final PathAddress partitionManagerAddress = this.getParentAddress(context.getCurrentAddress());
        Resource partitionManagerResource = context.readResourceFromRoot(partitionManagerAddress);
        this.checkIfLastConfiguration(partitionManagerResource);
        final ModelNode originalParentModel = Resource.Tools.readModel((Resource)partitionManagerResource);
        super.updateModel(context, operation);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                PartitionManagerRemoveHandler.INSTANCE.removeIdentityStoreServices(context, originalParentModel, partitionManagerAddress.getLastElement().getValue(), context.getCurrentAddressValue());
                context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
        PartitionManagerAddHandler.INSTANCE.createPartitionManagerService(context, parentAddress.getLastElement().getValue(), parentModel, false);
    }

    protected ServiceName getParentServiceName(PathAddress parentAddress) {
        return PartitionManagerService.createServiceName(parentAddress.getLastElement().getValue());
    }

    private void checkIfLastConfiguration(Resource partitionManagerResource) throws OperationFailedException {
        Set configurations = partitionManagerResource.getChildren(ModelElement.IDENTITY_CONFIGURATION.getName());
        if (configurations.isEmpty() || configurations.size() == 1) {
            throw PicketLinkLogger.ROOT_LOGGER.idmNoIdentityConfigurationProvided();
        }
    }
}

