/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.lms;

import java.io.IOException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.pqc.crypto.MessageSigner;
import org.bouncycastle.pqc.crypto.lms.HSS;
import org.bouncycastle.pqc.crypto.lms.HSSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.lms.HSSPublicKeyParameters;
import org.bouncycastle.pqc.crypto.lms.HSSSignature;

public class HSSSigner
implements MessageSigner {
    private HSSPrivateKeyParameters privKey;
    private HSSPublicKeyParameters pubKey;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            this.privKey = (HSSPrivateKeyParameters)param;
        } else {
            this.pubKey = (HSSPublicKeyParameters)param;
        }
    }

    @Override
    public byte[] generateSignature(byte[] message) {
        try {
            return HSS.generateSignature(this.privKey, message).getEncoded();
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to encode signature: " + e.getMessage());
        }
    }

    @Override
    public boolean verifySignature(byte[] message, byte[] signature) {
        try {
            return HSS.verifySignature(this.pubKey, HSSSignature.getInstance(signature, this.pubKey.getL()), message);
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to decode signature: " + e.getMessage());
        }
    }
}

