/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import javax.transaction.Transaction;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.synchronization.SyncLocalTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.LocalXaTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareLocalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareRemoteTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class TransactionFactory {
    private static final Log log = LogFactory.getLog(TransactionFactory.class);
    @Inject
    Configuration configuration;
    @Inject
    @ComponentName(value="org.infinispan.transaction.versionGenerator")
    VersionGenerator clusterIdGenerator;
    @Inject
    TimeService timeService;
    private TxFactoryEnum txFactoryEnum;
    private boolean isClustered;

    public GlobalTransaction newGlobalTransaction(Address addr, boolean remote) {
        return this.txFactoryEnum.newGlobalTransaction(addr, remote, this.clusterIdGenerator, this.isClustered);
    }

    public LocalTransaction newLocalTransaction(Transaction tx, GlobalTransaction gtx, boolean implicitTransaction, int topologyId) {
        return this.txFactoryEnum.newLocalTransaction(tx, gtx, implicitTransaction, topologyId, this.timeService.time());
    }

    public RemoteTransaction newRemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx, int topologyId) {
        return this.txFactoryEnum.newRemoteTransaction(modifications, tx, topologyId, this.timeService.time());
    }

    public RemoteTransaction newRemoteTransaction(GlobalTransaction tx, int topologyId) {
        return this.txFactoryEnum.newRemoteTransaction(tx, topologyId, this.timeService.time());
    }

    @Start
    public void start() {
        boolean xa = !this.configuration.transaction().useSynchronization();
        boolean recoveryEnabled = this.configuration.transaction().recovery().enabled();
        boolean batchingEnabled = this.configuration.invocationBatching().enabled();
        this.init(false, recoveryEnabled, xa, batchingEnabled);
        this.isClustered = this.configuration.clustering().cacheMode().isClustered();
    }

    public void init(boolean dldEnabled, boolean recoveryEnabled, boolean xa, boolean batchingEnabled) {
        this.txFactoryEnum = batchingEnabled ? TxFactoryEnum.NODLD_NORECOVERY_NOXA : (recoveryEnabled ? (xa ? TxFactoryEnum.NODLD_RECOVERY_XA : TxFactoryEnum.NODLD_NORECOVERY_NOXA) : (xa ? TxFactoryEnum.NODLD_NORECOVERY_XA : TxFactoryEnum.NODLD_NORECOVERY_NOXA));
        log.tracef("Setting factory enum to %s", (Object)this.txFactoryEnum);
    }

    public static enum TxFactoryEnum {
        NODLD_RECOVERY_XA{

            @Override
            public LocalTransaction newLocalTransaction(Transaction tx, GlobalTransaction gtx, boolean implicitTransaction, int topologyId, long txCreationTime) {
                return new RecoveryAwareLocalTransaction(tx, gtx, implicitTransaction, topologyId, txCreationTime);
            }

            @Override
            public GlobalTransaction newGlobalTransaction(Address addr, boolean remote, VersionGenerator clusterIdGenerator, boolean clustered) {
                GlobalTransaction recoveryAwareGlobalTransaction = new GlobalTransaction(addr, remote);
                recoveryAwareGlobalTransaction.setInternalId(((NumericVersion)clusterIdGenerator.generateNew()).getVersion());
                return recoveryAwareGlobalTransaction;
            }

            @Override
            public RemoteTransaction newRemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx, int topologyId, long txCreationTime) {
                return new RecoveryAwareRemoteTransaction(modifications, tx, topologyId, txCreationTime);
            }

            @Override
            public RemoteTransaction newRemoteTransaction(GlobalTransaction tx, int topologyId, long txCreationTime) {
                return new RecoveryAwareRemoteTransaction(tx, topologyId, txCreationTime);
            }
        }
        ,
        NODLD_NORECOVERY_XA{

            @Override
            public LocalTransaction newLocalTransaction(Transaction tx, GlobalTransaction gtx, boolean implicitTransaction, int topologyId, long txCreationTime) {
                return new LocalXaTransaction(tx, gtx, implicitTransaction, topologyId, txCreationTime);
            }

            @Override
            public GlobalTransaction newGlobalTransaction(Address addr, boolean remote, VersionGenerator clusterIdGenerator, boolean clustered) {
                return new GlobalTransaction(addr, remote);
            }

            @Override
            public RemoteTransaction newRemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx, int topologyId, long txCreationTime) {
                return new RemoteTransaction(modifications, tx, topologyId, txCreationTime);
            }

            @Override
            public RemoteTransaction newRemoteTransaction(GlobalTransaction tx, int topologyId, long txCreationTime) {
                return new RemoteTransaction(tx, topologyId, txCreationTime);
            }
        }
        ,
        NODLD_NORECOVERY_NOXA{

            @Override
            public LocalTransaction newLocalTransaction(Transaction tx, GlobalTransaction gtx, boolean implicitTransaction, int topologyId, long txCreationTime) {
                return new SyncLocalTransaction(tx, gtx, implicitTransaction, topologyId, txCreationTime);
            }

            @Override
            public GlobalTransaction newGlobalTransaction(Address addr, boolean remote, VersionGenerator clusterIdGenerator, boolean clustered) {
                return new GlobalTransaction(addr, remote);
            }

            @Override
            public RemoteTransaction newRemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx, int topologyId, long txCreationTime) {
                return new RemoteTransaction(modifications, tx, topologyId, txCreationTime);
            }

            @Override
            public RemoteTransaction newRemoteTransaction(GlobalTransaction tx, int topologyId, long txCreationTime) {
                return new RemoteTransaction(tx, topologyId, txCreationTime);
            }
        };


        public abstract LocalTransaction newLocalTransaction(Transaction var1, GlobalTransaction var2, boolean var3, int var4, long var5);

        public abstract GlobalTransaction newGlobalTransaction(Address var1, boolean var2, VersionGenerator var3, boolean var4);

        public abstract RemoteTransaction newRemoteTransaction(WriteCommand[] var1, GlobalTransaction var2, int var3, long var4);

        public abstract RemoteTransaction newRemoteTransaction(GlobalTransaction var1, int var2, long var3);
    }
}

