/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.jboss;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.migration.core.jboss.Subsystem;

public class Extension {
    private final String module;
    protected final Map<String, Subsystem> subsystems;

    protected Extension(Builder builder) {
        this.module = builder.module;
        if (this.module == null) {
            throw new IllegalArgumentException();
        }
        Stream subsystemBuilderStream = builder.subsystems.stream();
        this.subsystems = Collections.unmodifiableMap(subsystemBuilderStream.map(subsystemBuilder -> ((Subsystem.Builder)subsystemBuilder.extension(this)).build()).collect(Collectors.toMap(Subsystem::getName, Function.identity())));
    }

    public String getModule() {
        return this.module;
    }

    public Collection<Subsystem> getSubsystems() {
        return this.subsystems.values();
    }

    public Set<String> getSubsystemNames() {
        return this.subsystems.keySet();
    }

    public Subsystem getSubsystem(String subsystemName) {
        return this.subsystems.get(subsystemName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Extension that = (Extension)o;
        return this.module.equals(that.module);
    }

    public int hashCode() {
        return this.module.hashCode();
    }

    public String toString() {
        return this.module;
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    private static class DefaultBuilder
    extends Builder<DefaultBuilder> {
        private DefaultBuilder() {
        }

        @Override
        protected DefaultBuilder getThis() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        private final List<Subsystem.Builder> subsystems = new ArrayList<Subsystem.Builder>();
        private String module;

        protected abstract T getThis();

        public T module(String module) {
            this.module = module;
            return this.getThis();
        }

        public T subsystem(String subsystemName) {
            return this.subsystem((Subsystem.Builder)Subsystem.builder().name(subsystemName));
        }

        public T subsystem(Subsystem.Builder subsystemBuilder) {
            this.subsystems.add(subsystemBuilder);
            return this.getThis();
        }

        public Extension build() {
            return new Extension(this);
        }
    }
}

