/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.jdkspecific;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ProcessInfo {
    private final String name;
    private final long pid;
    private final List<String> arguments;

    private ProcessInfo() {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        String[] nameParts = runtimeMxBean.getName().split("@");
        this.name = runtimeMxBean.getName();
        this.pid = Long.parseLong(nameParts[0]);
        this.arguments = runtimeMxBean.getInputArguments();
    }

    public static ProcessInfo getInstance() {
        return new ProcessInfo();
    }

    public static ProcessInfo of(Process process) {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.name;
    }

    public long getPid() {
        return this.pid;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public ProcessInfo getParent() {
        return null;
    }

    public String toString() {
        return "Process{name='" + this.name + '\'' + ", pid=" + this.pid + ", arguments=" + this.arguments + '}';
    }
}

