/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import java.io.StringReader;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.james.mime4j.field.AbstractField;
import org.apache.james.mime4j.field.FieldParser;
import org.apache.james.mime4j.field.ParsedField;
import org.apache.james.mime4j.field.datetime.parser.DateTimeParser;
import org.apache.james.mime4j.field.datetime.parser.ParseException;
import org.apache.james.mime4j.field.datetime.parser.TokenMgrError;
import org.apache.james.mime4j.util.ByteSequence;

public class DateTimeField
extends AbstractField {
    private static Log log = LogFactory.getLog(DateTimeField.class);
    private boolean parsed = false;
    private Date date;
    private ParseException parseException;
    static final FieldParser PARSER = new FieldParser(){

        @Override
        public ParsedField parse(String name, String body, ByteSequence raw) {
            return new DateTimeField(name, body, raw);
        }
    };

    DateTimeField(String name, String body, ByteSequence raw) {
        super(name, body, raw);
    }

    public Date getDate() {
        if (!this.parsed) {
            this.parse();
        }
        return this.date;
    }

    @Override
    public ParseException getParseException() {
        if (!this.parsed) {
            this.parse();
        }
        return this.parseException;
    }

    private void parse() {
        String body = this.getBody();
        try {
            this.date = new DateTimeParser(new StringReader(body)).parseAll().getDate();
        }
        catch (ParseException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsing value '" + body + "': " + e.getMessage()));
            }
            this.parseException = e;
        }
        catch (TokenMgrError e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsing value '" + body + "': " + e.getMessage()));
            }
            this.parseException = new ParseException(e.getMessage());
        }
        this.parsed = true;
    }
}

