/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;

public class PGPKeyRingGenerator {
    List keys = new ArrayList();
    private PBESecretKeyEncryptor keyEncryptor;
    private PGPDigestCalculator checksumCalculator;
    private PGPKeyPair masterKey;
    private PGPSignatureSubpacketVector hashedPcks;
    private PGPSignatureSubpacketVector unhashedPcks;
    private PGPContentSignerBuilder keySignerBuilder;

    public PGPKeyRingGenerator(int certificationLevel, PGPKeyPair masterKey, String id, PGPDigestCalculator checksumCalculator, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, PGPContentSignerBuilder keySignerBuilder, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        this.masterKey = masterKey;
        this.keyEncryptor = keyEncryptor;
        this.checksumCalculator = checksumCalculator;
        this.keySignerBuilder = keySignerBuilder;
        this.hashedPcks = hashedPcks;
        this.unhashedPcks = unhashedPcks;
        this.keys.add(new PGPSecretKey(certificationLevel, masterKey, id, checksumCalculator, hashedPcks, unhashedPcks, keySignerBuilder, keyEncryptor));
    }

    public PGPKeyRingGenerator(PGPSecretKeyRing originalSecretRing, PBESecretKeyDecryptor secretKeyDecryptor, PGPDigestCalculator checksumCalculator, PGPContentSignerBuilder keySignerBuilder, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        this.masterKey = new PGPKeyPair(originalSecretRing.getPublicKey(), originalSecretRing.getSecretKey().extractPrivateKey(secretKeyDecryptor));
        this.keyEncryptor = keyEncryptor;
        this.checksumCalculator = checksumCalculator;
        this.keySignerBuilder = keySignerBuilder;
        PGPSignature certSig = (PGPSignature)originalSecretRing.getPublicKey().getSignatures().next();
        ArrayList<SignatureSubpacket> hashedVec = new ArrayList<SignatureSubpacket>();
        PGPSignatureSubpacketVector existing = certSig.getHashedSubPackets();
        for (int i = 0; i != existing.size(); ++i) {
            if (existing.packets[i].getType() == 2) continue;
            hashedVec.add(existing.packets[i]);
        }
        this.hashedPcks = new PGPSignatureSubpacketVector(hashedVec.toArray(new SignatureSubpacket[hashedVec.size()]));
        this.unhashedPcks = certSig.getUnhashedSubPackets();
        this.keys.addAll(originalSecretRing.keys);
    }

    public void addSubKey(PGPKeyPair keyPair) throws PGPException {
        this.addSubKey(keyPair, this.hashedPcks, this.unhashedPcks);
    }

    public void addSubKey(PGPKeyPair keyPair, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks) throws PGPException {
        try {
            PGPSignatureGenerator sGen = new PGPSignatureGenerator(this.keySignerBuilder);
            sGen.init(24, this.masterKey.getPrivateKey());
            sGen.setHashedSubpackets(hashedPcks);
            sGen.setUnhashedSubpackets(unhashedPcks);
            ArrayList<PGPSignature> subSigs = new ArrayList<PGPSignature>();
            subSigs.add(sGen.generateCertification(this.masterKey.getPublicKey(), keyPair.getPublicKey()));
            PGPPublicKey pubSubKey = new PGPPublicKey(keyPair.getPublicKey(), null, subSigs);
            pubSubKey.publicPk = new PublicSubkeyPacket(pubSubKey.getAlgorithm(), pubSubKey.getCreationTime(), pubSubKey.publicPk.getKey());
            this.keys.add(new PGPSecretKey(keyPair.getPrivateKey(), pubSubKey, this.checksumCalculator, this.keyEncryptor));
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("exception adding subkey: ", e);
        }
    }

    public PGPSecretKeyRing generateSecretKeyRing() {
        return new PGPSecretKeyRing(this.keys);
    }

    public PGPPublicKeyRing generatePublicKeyRing() {
        Iterator it = this.keys.iterator();
        ArrayList<PGPPublicKey> pubKeys = new ArrayList<PGPPublicKey>();
        pubKeys.add(((PGPSecretKey)it.next()).getPublicKey());
        while (it.hasNext()) {
            pubKeys.add(((PGPSecretKey)it.next()).getPublicKey());
        }
        return new PGPPublicKeyRing(pubKeys);
    }
}

