/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.idm.service;

import java.util.Collection;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.internal.DefaultPartitionManager;
import org.wildfly.extension.picketlink.logging.PicketLinkLogger;

public class PartitionManagerService
implements Service<PartitionManager> {
    private static final String SERVICE_NAME_PREFIX = "PartitionManagerService";
    private final String jndiName;
    private final String alias;
    private final IdentityConfigurationBuilder configurationBuilder;
    private volatile PartitionManager partitionManager;

    public PartitionManagerService(String alias, String jndiName, IdentityConfigurationBuilder configurationBuilder) {
        this.alias = alias;
        this.jndiName = jndiName;
        this.configurationBuilder = configurationBuilder;
    }

    public static ServiceName createServiceName(String alias) {
        return ServiceName.JBOSS.append(new String[]{"picketlink-identity-management", SERVICE_NAME_PREFIX, alias});
    }

    public static ServiceName createIdentityStoreServiceName(String name, String configurationName, String storeType) {
        return ServiceName.JBOSS.append(new String[]{"picketlink-identity-management", name, configurationName, storeType});
    }

    public PartitionManager getValue() throws IllegalStateException, IllegalArgumentException {
        return this.partitionManager;
    }

    public void start(StartContext context) throws StartException {
        PicketLinkLogger.ROOT_LOGGER.debugf("Starting PartitionManagerService for [%s]", this.alias);
        this.partitionManager = new DefaultPartitionManager((Collection)this.configurationBuilder.buildAll());
        this.publishPartitionManager(context);
    }

    public void stop(StopContext context) {
        PicketLinkLogger.ROOT_LOGGER.debugf("Stopping PartitionManagerService for [%s]", this.alias);
    }

    private void publishPartitionManager(StartContext context) {
        ContextNames.BindInfo bindInfo = this.createPartitionManagerBindInfo();
        ServiceName serviceName = bindInfo.getBinderServiceName();
        final BinderService binderService = new BinderService(serviceName.getCanonicalName());
        ServiceBuilder builder = context.getChildTarget().addService(serviceName, (Service)binderService).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{this.jndiName})});
        builder.addDependency(ContextNames.JAVA_CONTEXT_SERVICE_NAME, ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector());
        builder.addDependency(PartitionManagerService.createServiceName(this.alias), PartitionManager.class, (Injector)new Injector<PartitionManager>(){

            public void inject(PartitionManager value) throws InjectionException {
                binderService.getManagedObjectInjector().inject((Object)new ValueManagedReferenceFactory((Value)new ImmediateValue((Object)value)));
            }

            public void uninject() {
                binderService.getManagedObjectInjector().uninject();
            }
        });
        builder.setInitialMode(ServiceController.Mode.PASSIVE).install();
        PicketLinkLogger.ROOT_LOGGER.boundToJndi("PartitionManager " + this.alias, bindInfo.getAbsoluteJndiName());
    }

    private ContextNames.BindInfo createPartitionManagerBindInfo() {
        return ContextNames.bindInfoFor((String)this.jndiName);
    }

    public String getName() {
        return this.alias;
    }
}

