/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal;

import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncoderPersister;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.IOCompletion;
import org.apache.activemq.artemis.core.journal.JournalLoadInformation;
import org.apache.activemq.artemis.core.journal.LoaderCallback;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TransactionFailureCallback;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.utils.collections.SparseArrayLinkedList;

public interface Journal
extends ActiveMQComponent {
    public void setRemoveExtraFilesOnLoad(boolean var1);

    public boolean isRemoveExtraFilesOnLoad();

    public void appendAddRecord(long var1, byte var3, byte[] var4, boolean var5) throws Exception;

    default public void appendAddRecord(long id, byte recordType, EncodingSupport record, boolean sync) throws Exception {
        this.appendAddRecord(id, recordType, EncoderPersister.getInstance(), record, sync);
    }

    public void appendAddRecord(long var1, byte var3, Persister var4, Object var5, boolean var6) throws Exception;

    public void appendAddRecord(long var1, byte var3, Persister var4, Object var5, boolean var6, IOCompletion var7) throws Exception;

    default public void appendAddRecord(long id, byte recordType, EncodingSupport record, boolean sync, IOCompletion completionCallback) throws Exception {
        this.appendAddRecord(id, recordType, EncoderPersister.getInstance(), record, sync, completionCallback);
    }

    default public void replaceableRecord(byte recordType) {
    }

    public void appendUpdateRecord(long var1, byte var3, byte[] var4, boolean var5) throws Exception;

    public boolean tryAppendUpdateRecord(long var1, byte var3, byte[] var4, boolean var5) throws Exception;

    default public void appendUpdateRecord(long id, byte recordType, EncodingSupport record, boolean sync) throws Exception {
        this.appendUpdateRecord(id, recordType, EncoderPersister.getInstance(), record, sync);
    }

    default public boolean tryAppendUpdateRecord(long id, byte recordType, EncodingSupport record, boolean sync) throws Exception {
        return this.tryAppendUpdateRecord(id, recordType, EncoderPersister.getInstance(), record, sync);
    }

    public void appendUpdateRecord(long var1, byte var3, Persister var4, Object var5, boolean var6) throws Exception;

    public boolean tryAppendUpdateRecord(long var1, byte var3, Persister var4, Object var5, boolean var6) throws Exception;

    default public void appendUpdateRecord(long id, byte recordType, EncodingSupport record, boolean sync, IOCompletion completionCallback) throws Exception {
        this.appendUpdateRecord(id, recordType, EncoderPersister.getInstance(), record, sync, completionCallback);
    }

    default public boolean tryAppendUpdateRecord(long id, byte recordType, EncodingSupport record, boolean sync, IOCompletion completionCallback) throws Exception {
        return this.tryAppendUpdateRecord(id, recordType, EncoderPersister.getInstance(), record, sync, completionCallback);
    }

    public void appendUpdateRecord(long var1, byte var3, Persister var4, Object var5, boolean var6, IOCompletion var7) throws Exception;

    public boolean tryAppendUpdateRecord(long var1, byte var3, Persister var4, Object var5, boolean var6, IOCompletion var7) throws Exception;

    public void appendDeleteRecord(long var1, boolean var3) throws Exception;

    public boolean tryAppendDeleteRecord(long var1, boolean var3) throws Exception;

    public void appendDeleteRecord(long var1, boolean var3, IOCompletion var4) throws Exception;

    public boolean tryAppendDeleteRecord(long var1, boolean var3, IOCompletion var4) throws Exception;

    public void appendAddRecordTransactional(long var1, long var3, byte var5, byte[] var6) throws Exception;

    default public void appendAddRecordTransactional(long txID, long id, byte recordType, EncodingSupport record) throws Exception {
        this.appendAddRecordTransactional(txID, id, recordType, EncoderPersister.getInstance(), record);
    }

    public void appendAddRecordTransactional(long var1, long var3, byte var5, Persister var6, Object var7) throws Exception;

    public void appendUpdateRecordTransactional(long var1, long var3, byte var5, byte[] var6) throws Exception;

    default public void appendUpdateRecordTransactional(long txID, long id, byte recordType, EncodingSupport record) throws Exception {
        this.appendUpdateRecordTransactional(txID, id, recordType, EncoderPersister.getInstance(), record);
    }

    public void appendUpdateRecordTransactional(long var1, long var3, byte var5, Persister var6, Object var7) throws Exception;

    public void appendDeleteRecordTransactional(long var1, long var3, byte[] var5) throws Exception;

    public void appendDeleteRecordTransactional(long var1, long var3, EncodingSupport var5) throws Exception;

    public void appendDeleteRecordTransactional(long var1, long var3) throws Exception;

    public void appendCommitRecord(long var1, boolean var3) throws Exception;

    public void appendCommitRecord(long var1, boolean var3, IOCompletion var4) throws Exception;

    public void appendCommitRecord(long var1, boolean var3, IOCompletion var4, boolean var5) throws Exception;

    public void appendPrepareRecord(long var1, EncodingSupport var3, boolean var4) throws Exception;

    public void appendPrepareRecord(long var1, EncodingSupport var3, boolean var4, IOCompletion var5) throws Exception;

    public void appendPrepareRecord(long var1, byte[] var3, boolean var4) throws Exception;

    public void appendRollbackRecord(long var1, boolean var3) throws Exception;

    public void appendRollbackRecord(long var1, boolean var3, IOCompletion var4) throws Exception;

    public JournalLoadInformation load(LoaderCallback var1) throws Exception;

    public JournalLoadInformation loadInternalOnly() throws Exception;

    public JournalLoadInformation loadSyncOnly(JournalState var1) throws Exception;

    public void lineUpContext(IOCompletion var1);

    default public JournalLoadInformation load(List<RecordInfo> committedRecords, List<PreparedTransactionInfo> preparedTransactions, TransactionFailureCallback transactionFailure) throws Exception {
        return this.load(committedRecords, preparedTransactions, transactionFailure, true);
    }

    public JournalLoadInformation load(List<RecordInfo> var1, List<PreparedTransactionInfo> var2, TransactionFailureCallback var3, boolean var4) throws Exception;

    default public JournalLoadInformation load(SparseArrayLinkedList<RecordInfo> committedRecords, List<PreparedTransactionInfo> preparedTransactions, TransactionFailureCallback transactionFailure) throws Exception {
        return this.load(committedRecords, preparedTransactions, transactionFailure, true);
    }

    public JournalLoadInformation load(SparseArrayLinkedList<RecordInfo> var1, List<PreparedTransactionInfo> var2, TransactionFailureCallback var3, boolean var4) throws Exception;

    public int getAlignment() throws Exception;

    public int getNumberOfRecords();

    public int getUserVersion();

    public void runDirectJournalBlast() throws Exception;

    public Map<Long, JournalFile> createFilesForBackupSync(long[] var1) throws Exception;

    public void synchronizationLock();

    public void synchronizationUnlock();

    public void forceMoveNextFile() throws Exception;

    public JournalFile[] getDataFiles();

    public SequentialFileFactory getFileFactory();

    public int getFileSize();

    public void scheduleCompactAndBlock(int var1) throws Exception;

    public void replicationSyncPreserveOldFiles();

    public void replicationSyncFinished();

    public void flush() throws Exception;

    public long getMaxRecordSize();

    public static enum JournalState {
        STOPPED,
        STARTED,
        SYNCING,
        SYNCING_UP_TO_DATE,
        LOADED;

    }
}

