/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.jboss.weld.util.collections.AbstractMultimap;
import org.jboss.weld.util.collections.Multimap;

public class SetMultimap<K, V>
extends AbstractMultimap<K, V, Set<V>> {
    private static final long serialVersionUID = -7310409235342796148L;

    public static <K, V> SetMultimap<K, V> newSetMultimap() {
        return new SetMultimap<K, V>(HashMap::new, HashSet::new, null);
    }

    public static <K, V> SetMultimap<K, V> newSetMultimap(Multimap<K, V> multimap) {
        return new SetMultimap<K, V>(HashMap::new, HashSet::new, multimap);
    }

    public static <K, V> SetMultimap<K, V> newConcurrentSetMultimap() {
        return SetMultimap.newConcurrentSetMultimap(() -> Collections.synchronizedSet(new HashSet()));
    }

    public static <K, V> SetMultimap<K, V> newConcurrentSetMultimap(Supplier<Set<V>> valueSupplier) {
        return new SetMultimap<K, V>(ConcurrentHashMap::new, valueSupplier, null);
    }

    private SetMultimap(Supplier<Map<K, Set<V>>> mapSupplier, Supplier<Set<V>> collectionSupplier, Multimap<K, V> multimap) {
        super(mapSupplier, collectionSupplier, multimap);
    }
}

