/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.impl;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.util.impl.Closer;
import org.hibernate.search.util.impl.GenericCloseable;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class Closeables {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());

    private Closeables() {
    }

    public static <E extends Exception> void close(Iterable<? extends GenericCloseable<? extends E>> closeables) throws E {
        try (Closer closer = new Closer();){
            closer.pushAll(GenericCloseable::close, closeables);
        }
    }

    public static void closeQuietly(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException | RuntimeException e) {
                log.couldNotCloseResource(e);
            }
        }
    }

    @SafeVarargs
    public static void closeQuietly(Iterable<? extends Closeable> ... resourceIterables) {
        for (Iterable<? extends Closeable> resourceIterable : resourceIterables) {
            for (Closeable closeable : resourceIterable) {
                Closeables.closeQuietly(closeable);
            }
        }
    }
}

