/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.impl;

import org.wildfly.security.asn1.ASN1Decoder;
import org.wildfly.security.asn1.ASN1Encoder;
import org.wildfly.security.password.spec.MaskedPasswordAlgorithmSpec;
import org.wildfly.security.util.AbstractAlgorithmParametersSpiImpl;

public final class MaskedPasswordAlgorithmParametersSpiImpl
extends AbstractAlgorithmParametersSpiImpl<MaskedPasswordAlgorithmSpec> {
    @Override
    protected Class<MaskedPasswordAlgorithmSpec> getParameterType() {
        return MaskedPasswordAlgorithmSpec.class;
    }

    @Override
    protected void engineEncode(ASN1Encoder encoder, MaskedPasswordAlgorithmSpec parameterSpec) {
        encoder.startSequence();
        encoder.encodeOctetString(new String(parameterSpec.getInitialKeyMaterial()));
        encoder.encodeInteger(parameterSpec.getIterationCount());
        encoder.encodeOctetString(parameterSpec.getSalt());
        if (parameterSpec.getInitializationVector() != null) {
            encoder.encodeOctetString(parameterSpec.getInitializationVector());
        }
        encoder.endSequence();
    }

    @Override
    protected MaskedPasswordAlgorithmSpec engineDecode(ASN1Decoder decoder) {
        decoder.startSequence();
        char[] initialKeyMaterial = decoder.decodeOctetStringAsString().toCharArray();
        int iterationCount = decoder.decodeInteger().intValue();
        byte[] salt = decoder.decodeOctetString();
        byte[] initializationVector = decoder.hasNextElement() ? decoder.decodeOctetString() : null;
        decoder.endSequence();
        return new MaskedPasswordAlgorithmSpec(initialKeyMaterial, iterationCount, salt, initializationVector);
    }
}

