/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.interfaces;

import java.util.Arrays;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.password.interfaces.BCryptPassword;
import org.wildfly.security.password.interfaces.RawPassword;

class RawBCryptPassword
extends RawPassword
implements BCryptPassword {
    private static final long serialVersionUID = -3386914527972301638L;
    private final byte[] hash;
    private final byte[] salt;
    private final int iterationCount;

    RawBCryptPassword(String algorithm, byte[] hash, byte[] salt, int iterationCount) {
        super(algorithm);
        this.hash = hash;
        this.salt = salt;
        this.iterationCount = iterationCount;
    }

    @Override
    public byte[] getHash() {
        return (byte[])this.hash.clone();
    }

    @Override
    public byte[] getSalt() {
        return (byte[])this.salt.clone();
    }

    @Override
    public int getIterationCount() {
        return this.iterationCount;
    }

    @Override
    public RawBCryptPassword clone() {
        return this;
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashOrdered(HashMath.multiHashOrdered(Arrays.hashCode(this.hash), Arrays.hashCode(this.salt)), this.iterationCount);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RawBCryptPassword)) {
            return false;
        }
        RawBCryptPassword other = (RawBCryptPassword)obj;
        return this.iterationCount == other.iterationCount && Arrays.equals(this.hash, other.hash) && Arrays.equals(this.salt, other.salt) && this.getAlgorithm().equals(other.getAlgorithm());
    }
}

