/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CompositeIterator<E>
implements Iterator<E> {
    private final Iterable<? extends Iterator<? extends E>> iterators;

    @SafeVarargs
    public CompositeIterator(Iterator<? extends E> ... iterators) {
        this(Arrays.asList(iterators));
    }

    public CompositeIterator(Iterable<? extends Iterator<? extends E>> iterators) {
        this.iterators = iterators;
    }

    @Override
    public boolean hasNext() {
        for (Iterator<E> iterator : this.iterators) {
            if (!iterator.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public E next() {
        for (Iterator<E> iterator : this.iterators) {
            if (!iterator.hasNext()) continue;
            return iterator.next();
        }
        throw new NoSuchElementException();
    }
}

