/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.security;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialStoreUpdateInfo;
import org.jboss.as.controller.security.CredentialStoreUpdateService;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CommandCredentialSource;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.source.CredentialStoreCredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.util.PasswordBasedEncryptionUtil;

public final class CredentialReference {
    public static final String CREDENTIAL_STORE_CAPABILITY = "org.wildfly.security.credential-store";
    public static final String CREDENTIAL_REFERENCE = "credential-reference";
    public static final String STORE = "store";
    public static final String ALIAS = "alias";
    public static final String TYPE = "type";
    public static final String CLEAR_TEXT = "clear-text";
    public static final String CREDENTIAL_STORE_UPDATE = "credential-store-update";
    public static final String STATUS = "status";
    public static final String NEW_ENTRY_ADDED = "new-entry-added";
    public static final String EXISTING_ENTRY_UPDATED = "existing-entry-updated";
    public static final String NEW_ALIAS = "new-alias";
    public static final String UPDATE_ROLLED_BACK = "update-rolled-back";
    public static final String KEY_DELIMITER = ".";
    private static final OperationContext.AttachmentKey<Map<String, CredentialStoreUpdateInfo>> CREDENTIAL_STORE_UPDATE_INFO = OperationContext.AttachmentKey.create(Map.class);
    private static final SimpleAttributeDefinition credentialStoreAttribute;
    private static final SimpleAttributeDefinition credentialAliasAttribute;
    private static final SimpleAttributeDefinition credentialTypeAttribute;
    private static final SimpleAttributeDefinition clearTextAttribute;
    private static final SimpleAttributeDefinition credentialStoreAttributeWithCapabilityReference;
    private static final ObjectTypeAttributeDefinition credentialReferenceAD;
    private static final ObjectTypeAttributeDefinition credentialReferenceADWithCapabilityReference;
    private static final String CREDENTIAL_STORE_API_CAPABILITY = "org.wildfly.security.credential-store-api";
    private static final SecureRandom RANDOM;
    private static final String CHARS = "abcdefghijklmnopqrstuvwxyz0123456789";
    public static final RejectAttributeChecker REJECT_CREDENTIAL_REFERENCE_WITH_BOTH_STORE_AND_CLEAR_TEXT;

    private CredentialReference() {
    }

    public static ObjectTypeAttributeDefinition getAttributeDefinition() {
        return credentialReferenceAD;
    }

    public static ObjectTypeAttributeDefinition getAttributeDefinition(boolean referenceCredentialStore) {
        return referenceCredentialStore ? credentialReferenceADWithCapabilityReference : credentialReferenceAD;
    }

    public static ObjectTypeAttributeDefinition.Builder getAttributeBuilder(boolean allowNull, boolean referenceCredentialStore) {
        SimpleAttributeDefinition csAttr = referenceCredentialStore ? credentialStoreAttributeWithCapabilityReference : credentialStoreAttribute;
        return CredentialReference.getAttributeBuilder(CREDENTIAL_REFERENCE, CREDENTIAL_REFERENCE, allowNull, csAttr);
    }

    public static ObjectTypeAttributeDefinition.Builder getAttributeBuilder(String name, String xmlName, boolean allowNull) {
        return CredentialReference.getAttributeBuilder(name, xmlName, allowNull, false);
    }

    public static ObjectTypeAttributeDefinition.Builder getAttributeBuilder(String name, String xmlName, boolean allowNull, boolean referenceCredentialStore) {
        SimpleAttributeDefinition csAttr = referenceCredentialStore ? credentialStoreAttributeWithCapabilityReference : credentialStoreAttribute;
        return CredentialReference.getAttributeBuilder(name, xmlName, allowNull, csAttr);
    }

    public static ObjectTypeAttributeDefinition.Builder getAttributeBuilder(String name, String xmlName, boolean allowNull, CapabilityReferenceRecorder capabilityStoreReferenceRecorder) {
        if (capabilityStoreReferenceRecorder == null) {
            return CredentialReference.getAttributeBuilder(name, xmlName, allowNull, false);
        }
        assert (CREDENTIAL_STORE_CAPABILITY.equals(capabilityStoreReferenceRecorder.getBaseRequirementName()));
        SimpleAttributeDefinition csAttr = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(credentialStoreAttribute).setCapabilityReference(capabilityStoreReferenceRecorder)).build();
        return CredentialReference.getAttributeBuilder(name, xmlName, allowNull, csAttr);
    }

    private static ObjectTypeAttributeDefinition.Builder getAttributeBuilder(String name, String xmlName, boolean allowNull, AttributeDefinition credentialStoreDefinition) {
        return (ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder(name, credentialStoreDefinition, credentialAliasAttribute, credentialTypeAttribute, clearTextAttribute).setXmlName(xmlName)).setAttributeMarshaller(AttributeMarshaller.ATTRIBUTE_OBJECT)).setAttributeParser(AttributeParser.OBJECT_PARSER)).setRequired(!allowNull)).setAccessConstraints(SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).setValidator(new CredentialReferenceValidator());
    }

    public static String credentialReferencePartAsStringIfDefined(ModelNode credentialReferenceValue, String name) throws OperationFailedException {
        ModelNode result;
        assert (credentialReferenceValue.isDefined()) : credentialReferenceValue;
        if (credentialReferenceValue.hasDefined(name) && (result = credentialReferenceValue.get(name)).isDefined()) {
            return result.asString();
        }
        return null;
    }

    public static ExceptionSupplier<CredentialSource, Exception> getCredentialSourceSupplier(OperationContext context, ObjectTypeAttributeDefinition credentialReferenceAttributeDefinition, ModelNode model, ServiceBuilder<?> serviceBuilder) throws OperationFailedException {
        return CredentialReference.getCredentialSourceSupplier(context, credentialReferenceAttributeDefinition, model, serviceBuilder, null);
    }

    public static ExceptionSupplier<CredentialSource, Exception> getCredentialSourceSupplier(OperationContext context, ObjectTypeAttributeDefinition credentialReferenceAttributeDefinition, ModelNode model, ServiceBuilder<?> serviceBuilder, String keySuffix) throws OperationFailedException {
        ServiceRegistry serviceRegistry;
        ServiceName credentialStoreServiceName;
        String secret;
        String credentialType;
        String credentialAlias;
        String credentialStoreName;
        ModelNode value = credentialReferenceAttributeDefinition.resolveModelAttribute(context, model);
        if (serviceBuilder == null) {
            CredentialReference.handleCredentialReferenceUpdate(context, value, credentialReferenceAttributeDefinition.getName());
        }
        String key = CredentialReference.getAttachmentMapKey(context, keySuffix, credentialReferenceAttributeDefinition.getName());
        CredentialStoreUpdateInfo credentialStoreUpdateInfo = null;
        if (value.isDefined()) {
            credentialStoreName = CredentialReference.credentialReferencePartAsStringIfDefined(value, STORE);
            credentialAlias = CredentialReference.credentialReferencePartAsStringIfDefined(value, ALIAS);
            credentialType = CredentialReference.credentialReferencePartAsStringIfDefined(value, TYPE);
            if (value.hasDefined(CLEAR_TEXT)) {
                secret = value.get(CLEAR_TEXT).asString();
            } else {
                Map<String, CredentialStoreUpdateInfo> credentialStoreUpdateInfoMap = context.getAttachment(CREDENTIAL_STORE_UPDATE_INFO);
                if (credentialStoreUpdateInfoMap == null) {
                    secret = null;
                } else {
                    credentialStoreUpdateInfo = credentialStoreUpdateInfoMap.get(key);
                    secret = credentialStoreUpdateInfo.getClearText();
                }
            }
        } else {
            credentialStoreName = null;
            credentialAlias = null;
            credentialType = null;
            secret = null;
        }
        if (credentialAlias != null) {
            String credentialStoreCapabilityName = RuntimeCapability.buildDynamicCapabilityName(CREDENTIAL_STORE_CAPABILITY, credentialStoreName);
            credentialStoreServiceName = context.getCapabilityServiceName(credentialStoreCapabilityName, CredentialStore.class);
            serviceRegistry = context.getServiceRegistry(true);
            if (serviceBuilder != null) {
                serviceBuilder.requires(credentialStoreServiceName);
                if (secret != null) {
                    ServiceName credentialStoreUpdateServiceName = CredentialStoreUpdateService.createServiceName(key, credentialStoreName);
                    CredentialStoreUpdateService credentialStoreUpdateService = new CredentialStoreUpdateService(credentialAlias, secret, context.getResult(), credentialStoreUpdateInfo);
                    ServiceBuilder credentialStoreUpdateServiceBuilder = context.getServiceTarget().addService(credentialStoreUpdateServiceName, (Service)credentialStoreUpdateService).setInitialMode(ServiceController.Mode.ACTIVE);
                    credentialStoreUpdateServiceBuilder.addDependency(context.getCapabilityServiceName(credentialStoreCapabilityName, CredentialStore.class), CredentialStore.class, credentialStoreUpdateService.getCredentialStoreInjector());
                    credentialStoreUpdateServiceBuilder.install();
                    serviceBuilder.requires(credentialStoreUpdateServiceName);
                }
            } else if (credentialAlias != null && secret != null) {
                CredentialStore credentialStore = CredentialReference.getCredentialStore(serviceRegistry, credentialStoreServiceName);
                try {
                    CredentialReference.updateCredentialStore(credentialStore, credentialAlias, secret, context.getResult(), credentialStoreUpdateInfo);
                }
                catch (CredentialStoreException e) {
                    throw new OperationFailedException(e);
                }
            }
        } else {
            credentialStoreServiceName = null;
            serviceRegistry = null;
        }
        return new ExceptionSupplier<CredentialSource, Exception>(){

            public CredentialSource get() throws Exception {
                if (credentialAlias != null) {
                    return new CredentialStoreCredentialSource(() -> {
                        ServiceController controller = serviceRegistry.getService(credentialStoreServiceName);
                        if (controller != null) {
                            Service credentialStoreService = controller.getService();
                            return (CredentialStore)credentialStoreService.getValue();
                        }
                        return null;
                    }, credentialAlias);
                }
                if (credentialType != null && credentialType.equalsIgnoreCase("COMMAND")) {
                    CommandCredentialSource.Builder command = CommandCredentialSource.builder();
                    String commandSpec = secret.trim();
                    String[] parts = commandSpec.startsWith("{EXT") ? CredentialReference.parseCommand(CredentialReference.stripType(commandSpec), " ") : (commandSpec.startsWith("{CMD") ? CredentialReference.parseCommand(CredentialReference.stripType(commandSpec), ",") : CredentialReference.parseCommand(commandSpec, " "));
                    for (String part : parts) {
                        command.addCommand(part);
                    }
                    return command.build();
                }
                if (secret != null && secret.startsWith("MASK-")) {
                    return new MaskCredentialSource(secret);
                }
                if (secret != null) {
                    return new ClearTextCredentialSource(secret);
                }
                return null;
            }
        };
    }

    static String[] parseCommand(String command, String delimiter) {
        String[] parsedCommand = command.split("(?<!\\\\)" + delimiter);
        for (int k = 0; k < parsedCommand.length; ++k) {
            if (parsedCommand[k].indexOf(92) == -1) continue;
            parsedCommand[k] = parsedCommand[k].replaceAll("\\\\" + delimiter, delimiter);
        }
        return parsedCommand;
    }

    static String stripType(String commandSpec) {
        StringTokenizer tokenizer = new StringTokenizer(commandSpec, "{}");
        tokenizer.nextToken();
        return tokenizer.nextToken();
    }

    public static CredentialSource getCredentialSource(OperationContext context, ObjectTypeAttributeDefinition credentialReferenceAttributeDefinition, ModelNode model) throws OperationFailedException {
        String clearText;
        ModelNode value = credentialReferenceAttributeDefinition.resolveModelAttribute(context, model);
        String credentialStoreName = value.isDefined() ? CredentialReference.credentialReferencePartAsStringIfDefined(value, STORE) : null;
        String credentialAlias = value.isDefined() ? CredentialReference.credentialReferencePartAsStringIfDefined(value, ALIAS) : null;
        String credentialType = value.isDefined() ? CredentialReference.credentialReferencePartAsStringIfDefined(value, TYPE) : null;
        String string = clearText = value.isDefined() && value.hasDefined(CLEAR_TEXT) ? value.get(CLEAR_TEXT).asString() : null;
        if (clearText != null) {
            if ("COMMAND".equals(credentialType)) {
                CommandCredentialSource.Builder command = CommandCredentialSource.builder();
                String commandSpec = clearText.trim();
                String[] parts = commandSpec.startsWith("{EXT") ? CredentialReference.parseCommand(CredentialReference.stripType(commandSpec), " ") : (commandSpec.startsWith("{CMD") ? CredentialReference.parseCommand(CredentialReference.stripType(commandSpec), ",") : CredentialReference.parseCommand(commandSpec, " "));
                for (String part : parts) {
                    command.addCommand(part);
                }
                try {
                    return command.build();
                }
                catch (GeneralSecurityException e) {
                    throw ControllerLogger.MGMT_OP_LOGGER.unableToBuildCommandCredentialSource(e);
                }
            }
            if (clearText.startsWith("MASK-")) {
                return new MaskCredentialSource(clearText);
            }
            return new ClearTextCredentialSource(clearText);
        }
        if (credentialStoreName != null && credentialAlias != null) {
            ExceptionFunction credentialStoreApi = context.getCapabilityRuntimeAPI(CREDENTIAL_STORE_API_CAPABILITY, credentialStoreName, ExceptionFunction.class);
            CredentialStore credentialStore = (CredentialStore)credentialStoreApi.apply((Object)context);
            return new CredentialStoreCredentialSource(() -> credentialStore, credentialAlias);
        }
        return null;
    }

    static CredentialStore getCredentialStore(ServiceRegistry serviceRegistry, ServiceName serviceName) {
        ServiceController serviceContainer = serviceRegistry.getRequiredService(serviceName);
        return (CredentialStore)serviceContainer.getService().getValue();
    }

    private static void storeSecret(CredentialStore credentialStore, String alias, String secretValue) throws CredentialStoreException {
        if (alias != null && secretValue != null) {
            char[] secret = secretValue.toCharArray();
            ClearPassword clearPassword = ClearPassword.createRaw((String)"clear", (char[])secret);
            credentialStore.store(alias, (Credential)new PasswordCredential((Password)clearPassword));
            try {
                credentialStore.flush();
            }
            catch (CredentialStoreException e) {
                credentialStore.remove(alias, PasswordCredential.class);
                throw e;
            }
        }
    }

    private static void removeSecret(CredentialStore credentialStore, String alias, String secretValue) throws CredentialStoreException {
        if (alias != null) {
            credentialStore.remove(alias, PasswordCredential.class);
            try {
                credentialStore.flush();
            }
            catch (CredentialStoreException e) {
                char[] secret = secretValue.toCharArray();
                ClearPassword clearPassword = ClearPassword.createRaw((String)"clear", (char[])secret);
                credentialStore.store(alias, (Credential)new PasswordCredential((Password)clearPassword));
                throw e;
            }
        }
    }

    static void updateCredentialStore(CredentialStore credentialStore, String alias, String secret, ModelNode result, CredentialStoreUpdateInfo credentialStoreUpdateInfo) throws CredentialStoreException {
        boolean exists = credentialStore.exists(alias, PasswordCredential.class);
        if (exists) {
            PasswordCredential passwordCredential = (PasswordCredential)credentialStore.retrieve(alias, PasswordCredential.class);
            ClearPassword clearPassword = (ClearPassword)passwordCredential.getPassword(ClearPassword.class);
            credentialStoreUpdateInfo.setPreviousClearText(String.valueOf(clearPassword.getPassword()));
            credentialStoreUpdateInfo.setPreviousAlias(alias);
        } else {
            credentialStoreUpdateInfo.setPreviousClearText(null);
            credentialStoreUpdateInfo.setPreviousAlias(null);
        }
        CredentialReference.storeSecret(credentialStore, alias, secret);
        ModelNode credentialStoreUpdateResult = result.get(CREDENTIAL_STORE_UPDATE);
        if (exists) {
            credentialStoreUpdateResult.get(STATUS).set(EXISTING_ENTRY_UPDATED);
        } else {
            credentialStoreUpdateResult.get(STATUS).set(NEW_ENTRY_ADDED);
            credentialStoreUpdateResult.get(NEW_ALIAS).set(alias);
        }
    }

    public static void handleCredentialReferenceUpdate(OperationContext context, ModelNode model) throws OperationFailedException {
        CredentialReference.handleCredentialReferenceUpdate(context, model.get(CREDENTIAL_REFERENCE), CREDENTIAL_REFERENCE);
    }

    public static void rollbackCredentialStoreUpdate(AttributeDefinition credentialReferenceAD, OperationContext context, Resource resource) {
        try {
            ModelNode value = credentialReferenceAD.resolveModelAttribute(context, resource.getModel());
            if (value.isDefined()) {
                String store = CredentialReference.credentialReferencePartAsStringIfDefined(value, STORE);
                String alias = CredentialReference.credentialReferencePartAsStringIfDefined(value, ALIAS);
                CredentialReference.rollbackCredentialStoreUpdate(credentialReferenceAD, context, store, alias);
            }
        }
        catch (OperationFailedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void rollbackCredentialStoreUpdate(AttributeDefinition credentialReferenceAD, OperationContext context, ModelNode resolvedValue) {
        if (resolvedValue.isDefined()) {
            try {
                String store = CredentialReference.credentialReferencePartAsStringIfDefined(resolvedValue, STORE);
                String alias = CredentialReference.credentialReferencePartAsStringIfDefined(resolvedValue, ALIAS);
                CredentialReference.rollbackCredentialStoreUpdate(credentialReferenceAD, context, store, alias);
            }
            catch (OperationFailedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void rollbackCredentialStoreUpdate(AttributeDefinition credentialReferenceAD, OperationContext context, String store, String alias) {
        try {
            CredentialStoreUpdateInfo credentialStoreUpdateInfo;
            Map<String, CredentialStoreUpdateInfo> credentialStoreUpdateInfoMap = context.getAttachment(CREDENTIAL_STORE_UPDATE_INFO);
            CredentialStoreUpdateInfo credentialStoreUpdateInfo2 = credentialStoreUpdateInfo = credentialStoreUpdateInfoMap != null ? credentialStoreUpdateInfoMap.get(CredentialReference.getAttachmentMapKey(context, credentialReferenceAD.getName())) : null;
            if (store != null && credentialStoreUpdateInfo != null && credentialStoreUpdateInfo.getClearText() != null) {
                String credentialStoreCapabilityName = RuntimeCapability.buildDynamicCapabilityName(CREDENTIAL_STORE_CAPABILITY, store);
                ServiceName credentialStoreServiceName = context.getCapabilityServiceName(credentialStoreCapabilityName, CredentialStore.class);
                CredentialStore credentialStore = CredentialReference.getCredentialStore(context.getServiceRegistry(true), credentialStoreServiceName);
                ModelNode credentialStoreUpdateResult = context.getResult().get(CREDENTIAL_STORE_UPDATE);
                if (credentialStoreUpdateInfo.getPreviousAlias() == null) {
                    CredentialReference.removeSecret(credentialStore, alias, credentialStoreUpdateInfo.getClearText());
                    credentialStoreUpdateResult.remove(NEW_ALIAS);
                } else {
                    CredentialReference.storeSecret(credentialStore, alias, credentialStoreUpdateInfo.getPreviousClearText());
                }
                credentialStoreUpdateResult.get(STATUS).set(UPDATE_ROLLED_BACK);
            }
        }
        catch (CredentialStoreException e) {
            throw new RuntimeException(e);
        }
    }

    public static void handleCredentialReferenceUpdate(OperationContext context, ModelNode credentialReference, String credentialReferenceAttributeName) throws OperationFailedException {
        String secret;
        String credentialType;
        String credentialAlias;
        String credentialStoreName;
        if (credentialReference.isDefined()) {
            credentialStoreName = CredentialReference.credentialReferencePartAsStringIfDefined(credentialReference, STORE);
            credentialAlias = CredentialReference.credentialReferencePartAsStringIfDefined(credentialReference, ALIAS);
            credentialType = CredentialReference.credentialReferencePartAsStringIfDefined(credentialReference, TYPE);
            secret = CredentialReference.credentialReferencePartAsStringIfDefined(credentialReference, CLEAR_TEXT);
        } else {
            credentialStoreName = null;
            credentialAlias = null;
            credentialType = null;
            secret = null;
        }
        boolean removeSecret = false;
        if (credentialStoreName != null && secret != null) {
            if (credentialAlias != null) {
                removeSecret = true;
            } else if (!(credentialType != null && credentialType.equalsIgnoreCase("COMMAND") || secret.startsWith("MASK-"))) {
                credentialReference.get(ALIAS).set(CredentialReference.generateAlias());
                removeSecret = true;
            }
            if (removeSecret) {
                Map<String, CredentialStoreUpdateInfo> credentialStoreUpdateInfoMap = context.getAttachment(CREDENTIAL_STORE_UPDATE_INFO);
                if (credentialStoreUpdateInfoMap == null) {
                    credentialStoreUpdateInfoMap = Collections.synchronizedMap(new HashMap());
                    context.attach(CREDENTIAL_STORE_UPDATE_INFO, credentialStoreUpdateInfoMap);
                }
                credentialStoreUpdateInfoMap.put(CredentialReference.getAttachmentMapKey(context, credentialReferenceAttributeName), new CredentialStoreUpdateInfo(secret));
                credentialReference.get(CLEAR_TEXT).set(new ModelNode());
            }
        }
    }

    public static boolean applyCredentialReferenceUpdateToRuntime(OperationContext context, ModelNode operation, ModelNode resolvedValue, ModelNode currentValue, String attributeName) throws OperationFailedException {
        if (resolvedValue.isDefined()) {
            String store = CredentialReference.credentialReferencePartAsStringIfDefined(resolvedValue, STORE);
            String alias = CredentialReference.credentialReferencePartAsStringIfDefined(resolvedValue, ALIAS);
            String secret = CredentialReference.credentialReferencePartAsStringIfDefined(operation.get("value"), CLEAR_TEXT);
            if (alias != null && secret != null) {
                String credentialStoreCapabilityName = RuntimeCapability.buildDynamicCapabilityName(CREDENTIAL_STORE_CAPABILITY, store);
                ServiceName credentialStoreServiceName = context.getCapabilityServiceName(credentialStoreCapabilityName, CredentialStore.class);
                CredentialStore credentialStore = CredentialReference.getCredentialStore(context.getServiceRegistry(true), credentialStoreServiceName);
                try {
                    Map<String, CredentialStoreUpdateInfo> credentialStoreUpdateInfoMap = context.getAttachment(CREDENTIAL_STORE_UPDATE_INFO);
                    CredentialStoreUpdateInfo credentialStoreUpdateInfo = credentialStoreUpdateInfoMap.get(CredentialReference.getAttachmentMapKey(context, attributeName));
                    CredentialReference.updateCredentialStore(credentialStore, alias, secret, context.getResult(), credentialStoreUpdateInfo);
                }
                catch (CredentialStoreException e) {
                    throw new OperationFailedException(e);
                }
            }
        }
        return !operation.get("value").equals(currentValue);
    }

    private static String generateAlias() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            int index = (int)(RANDOM.nextDouble() * (double)CHARS.length());
            builder.append(CHARS.substring(index, index + 1));
        }
        return builder.toString();
    }

    private static String getAttachmentMapKey(OperationContext context, String credentialReferenceAttributeName) {
        return CredentialReference.getAttachmentMapKey(context, null, credentialReferenceAttributeName);
    }

    private static String getAttachmentMapKey(OperationContext context, String keySuffix, String credentialReferenceAttributeName) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getCurrentAddress().toPathStyleString().replaceFirst("/", "").replace("/", KEY_DELIMITER));
        if (keySuffix != null) {
            sb.append(KEY_DELIMITER).append(keySuffix);
        }
        sb.append(KEY_DELIMITER).append(credentialReferenceAttributeName);
        return sb.toString();
    }

    static {
        RANDOM = new SecureRandom();
        credentialStoreAttribute = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(STORE, ModelType.STRING, true).setXmlName(STORE)).build();
        credentialAliasAttribute = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ALIAS, ModelType.STRING, true).setXmlName(ALIAS)).setAllowExpression(true)).setRequires(STORE)).build();
        credentialTypeAttribute = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(TYPE, ModelType.STRING, true).setXmlName(TYPE)).setAllowExpression(true)).build();
        clearTextAttribute = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(CLEAR_TEXT, ModelType.STRING, true).setXmlName(CLEAR_TEXT)).setAllowExpression(true)).build();
        credentialReferenceAD = ((ObjectTypeAttributeDefinition.Builder)CredentialReference.getAttributeBuilder(CREDENTIAL_REFERENCE, CREDENTIAL_REFERENCE, false, false).setRestartAllServices()).build();
        credentialStoreAttributeWithCapabilityReference = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(credentialStoreAttribute).setCapabilityReference(CREDENTIAL_STORE_CAPABILITY)).build();
        credentialReferenceADWithCapabilityReference = ((ObjectTypeAttributeDefinition.Builder)CredentialReference.getAttributeBuilder(CREDENTIAL_REFERENCE, CREDENTIAL_REFERENCE, false, true).setRestartAllServices()).build();
        REJECT_CREDENTIAL_REFERENCE_WITH_BOTH_STORE_AND_CLEAR_TEXT = new RejectAttributeChecker.DefaultRejectAttributeChecker(){

            @Override
            public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
                return ControllerLogger.ROOT_LOGGER.invalidAttributeValue(CredentialReference.CLEAR_TEXT).getMessage();
            }

            @Override
            protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                if (attributeValue.isDefined()) {
                    String store = null;
                    String secret = null;
                    if (attributeValue.hasDefined(CredentialReference.STORE)) {
                        store = attributeValue.get(CredentialReference.STORE).asString();
                    }
                    if (attributeValue.hasDefined(CredentialReference.CLEAR_TEXT)) {
                        secret = attributeValue.get(CredentialReference.CLEAR_TEXT).asString();
                    }
                    return store != null && secret != null;
                }
                return false;
            }
        };
    }

    static class ClearTextCredentialSource
    implements CredentialSource {
        private final String secret;

        ClearTextCredentialSource(String secret) {
            this.secret = secret;
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
            return credentialType == PasswordCredential.class ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
        }

        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
            return (C)((Credential)credentialType.cast(new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])this.secret.toCharArray()))));
        }
    }

    static class MaskCredentialSource
    implements CredentialSource {
        private final String secret;

        MaskCredentialSource(String secret) {
            this.secret = secret;
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
            return credentialType == PasswordCredential.class ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
        }

        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
            int iterationCount;
            String[] part = this.secret.substring(5).split(";");
            if (part.length != 3) {
                throw ControllerLogger.ROOT_LOGGER.wrongMaskedPasswordFormat();
            }
            String salt = part[1];
            try {
                iterationCount = Integer.parseInt(part[2]);
            }
            catch (NumberFormatException e) {
                throw ControllerLogger.ROOT_LOGGER.wrongMaskedPasswordFormat();
            }
            try {
                PasswordBasedEncryptionUtil decryptUtil = new PasswordBasedEncryptionUtil.Builder().picketBoxCompatibility().salt(salt).iteration(iterationCount).decryptMode().build();
                return (C)((Credential)credentialType.cast(new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])decryptUtil.decodeAndDecrypt(part[0])))));
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
        }
    }

    private static class CredentialReferenceValidator
    implements ParameterValidator {
        private CredentialReferenceValidator() {
        }

        @Override
        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            if (value.isDefined()) {
                String store = null;
                String secret = null;
                String alias = null;
                if (value.hasDefined(CredentialReference.STORE)) {
                    store = value.get(CredentialReference.STORE).asString();
                }
                if (value.hasDefined(CredentialReference.CLEAR_TEXT)) {
                    secret = value.get(CredentialReference.CLEAR_TEXT).asString();
                }
                if (value.hasDefined(CredentialReference.ALIAS)) {
                    alias = value.get(CredentialReference.ALIAS).asString();
                }
                boolean valid = false;
                if (secret != null && store == null && alias == null) {
                    valid = true;
                } else if (store != null && (secret != null || alias != null)) {
                    valid = true;
                }
                if (!valid) {
                    throw ControllerLogger.ROOT_LOGGER.invalidCredentialReferenceValue(parameterName, CredentialReference.CLEAR_TEXT, CredentialReference.STORE, CredentialReference.CLEAR_TEXT, CredentialReference.ALIAS);
                }
            }
        }
    }
}

