/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.io.IOException;
import java.io.Writer;
import nu.xom.TextWriter;
import nu.xom.XMLException;

final class UnicodeWriter
extends TextWriter {
    UnicodeWriter(Writer out, String encoding) {
        super(out, encoding);
    }

    @Override
    boolean needsEscaping(char c) {
        return false;
    }

    @Override
    void writeMarkup(String s) throws IOException {
        int unicodeStringLength;
        if (this.normalize) {
            s = this.normalize(s);
        }
        if ((unicodeStringLength = UnicodeWriter.getUnicodeLengthForMarkup(s)) >= 0) {
            this.out.write(s);
            if (unicodeStringLength > 0) {
                this.column += unicodeStringLength;
                this.lastCharacterWasSpace = false;
                this.skipFollowingLinefeed = false;
                this.justBroke = false;
            }
        } else {
            int length = s.length();
            for (int i = 0; i < length; ++i) {
                this.writeMarkup(s.charAt(i));
            }
        }
    }

    @Override
    void writeName(String name) throws IOException {
        if (this.normalize) {
            name = this.normalize(name);
        }
        int unicodeStringLength = UnicodeWriter.getUnicodeLengthForName(name);
        this.out.write(name);
        this.column += unicodeStringLength;
        this.lastCharacterWasSpace = false;
        this.skipFollowingLinefeed = false;
        this.justBroke = false;
    }

    private static int getUnicodeLengthForMarkup(String s) {
        int unicodeLength = 0;
        int javaLength = s.length();
        for (int i = 0; i < javaLength; ++i) {
            char c = s.charAt(i);
            if (c <= ' ') {
                return -1;
            }
            if (c >= '\ud800' && c <= '\udbff') continue;
            ++unicodeLength;
        }
        return unicodeLength;
    }

    private static int getUnicodeLengthForName(String name) {
        int unicodeLength = 0;
        int javaLength = name.length();
        for (int i = 0; i < javaLength; ++i) {
            char c = name.charAt(i);
            if (c >= '\ud800' && c <= '\udbff') continue;
            ++unicodeLength;
        }
        return unicodeLength;
    }

    @Override
    void writeAttributeValue(String s) throws IOException {
        int unicodeStringLength;
        if (this.normalize) {
            s = this.normalize(s);
        }
        if ((unicodeStringLength = UnicodeWriter.getUnicodeLengthForAttributeValue(s)) >= 0) {
            this.out.write(s);
            if (unicodeStringLength > 0) {
                this.column += unicodeStringLength;
                this.lastCharacterWasSpace = false;
                this.skipFollowingLinefeed = false;
                this.justBroke = false;
            }
        } else {
            int length = s.length();
            for (int i = 0; i < length; ++i) {
                this.writeAttributeValue(s.charAt(i));
            }
        }
    }

    private static int getUnicodeLengthForAttributeValue(String s) {
        int unicodeLength = 0;
        int javaLength = s.length();
        block38: for (int i = 0; i < javaLength; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': {
                    return -1;
                }
                case '\n': {
                    return -1;
                }
                case '\u000b': 
                case '\f': {
                    throw new XMLException("Bad character snuck into document");
                }
                case '\r': {
                    return -1;
                }
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    throw new XMLException("Bad character snuck into document");
                }
                case ' ': {
                    return -1;
                }
                case '!': {
                    ++unicodeLength;
                    continue block38;
                }
                case '\"': {
                    return -1;
                }
                case '#': {
                    ++unicodeLength;
                    continue block38;
                }
                case '$': {
                    ++unicodeLength;
                    continue block38;
                }
                case '%': {
                    ++unicodeLength;
                    continue block38;
                }
                case '&': {
                    return -1;
                }
                case '\'': {
                    ++unicodeLength;
                    continue block38;
                }
                case '(': {
                    ++unicodeLength;
                    continue block38;
                }
                case ')': {
                    ++unicodeLength;
                    continue block38;
                }
                case '*': {
                    ++unicodeLength;
                    continue block38;
                }
                case '+': {
                    ++unicodeLength;
                    continue block38;
                }
                case ',': {
                    ++unicodeLength;
                    continue block38;
                }
                case '-': {
                    ++unicodeLength;
                    continue block38;
                }
                case '.': {
                    ++unicodeLength;
                    continue block38;
                }
                case '/': {
                    ++unicodeLength;
                    continue block38;
                }
                case '0': {
                    ++unicodeLength;
                    continue block38;
                }
                case '1': {
                    ++unicodeLength;
                    continue block38;
                }
                case '2': {
                    ++unicodeLength;
                    continue block38;
                }
                case '3': {
                    ++unicodeLength;
                    continue block38;
                }
                case '4': {
                    ++unicodeLength;
                    continue block38;
                }
                case '5': {
                    ++unicodeLength;
                    continue block38;
                }
                case '6': {
                    ++unicodeLength;
                    continue block38;
                }
                case '7': {
                    ++unicodeLength;
                    continue block38;
                }
                case '8': {
                    ++unicodeLength;
                    continue block38;
                }
                case '9': {
                    ++unicodeLength;
                    continue block38;
                }
                case ':': {
                    ++unicodeLength;
                    continue block38;
                }
                case ';': {
                    ++unicodeLength;
                    continue block38;
                }
                case '<': {
                    return -1;
                }
                case '=': {
                    ++unicodeLength;
                    continue block38;
                }
                case '>': {
                    return -1;
                }
                default: {
                    if (c >= '\ud800' && c <= '\udbff') continue block38;
                    ++unicodeLength;
                }
            }
        }
        return unicodeLength;
    }

    @Override
    void writePCDATA(String s) throws IOException {
        int unicodeStringLength;
        if (this.normalize) {
            s = this.normalize(s);
        }
        if ((unicodeStringLength = UnicodeWriter.getUnicodeLengthForPCDATA(s)) >= 0) {
            this.out.write(s);
            if (unicodeStringLength > 0) {
                this.column += unicodeStringLength;
                this.lastCharacterWasSpace = false;
                this.skipFollowingLinefeed = false;
                this.justBroke = false;
            }
        } else {
            int length = s.length();
            for (int i = 0; i < length; ++i) {
                this.writePCDATA(s.charAt(i));
            }
        }
    }

    private static int getUnicodeLengthForPCDATA(String s) {
        int unicodeLength = 0;
        int javaLength = s.length();
        block38: for (int i = 0; i < javaLength; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': {
                    return -1;
                }
                case '\n': {
                    return -1;
                }
                case '\u000b': 
                case '\f': {
                    throw new XMLException("Bad character snuck into document");
                }
                case '\r': {
                    return -1;
                }
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    throw new XMLException("Bad character snuck into document");
                }
                case ' ': {
                    return -1;
                }
                case '!': {
                    ++unicodeLength;
                    continue block38;
                }
                case '\"': {
                    ++unicodeLength;
                    continue block38;
                }
                case '#': {
                    ++unicodeLength;
                    continue block38;
                }
                case '$': {
                    ++unicodeLength;
                    continue block38;
                }
                case '%': {
                    ++unicodeLength;
                    continue block38;
                }
                case '&': {
                    return -1;
                }
                case '\'': {
                    ++unicodeLength;
                    continue block38;
                }
                case '(': {
                    ++unicodeLength;
                    continue block38;
                }
                case ')': {
                    ++unicodeLength;
                    continue block38;
                }
                case '*': {
                    ++unicodeLength;
                    continue block38;
                }
                case '+': {
                    ++unicodeLength;
                    continue block38;
                }
                case ',': {
                    ++unicodeLength;
                    continue block38;
                }
                case '-': {
                    ++unicodeLength;
                    continue block38;
                }
                case '.': {
                    ++unicodeLength;
                    continue block38;
                }
                case '/': {
                    ++unicodeLength;
                    continue block38;
                }
                case '0': {
                    ++unicodeLength;
                    continue block38;
                }
                case '1': {
                    ++unicodeLength;
                    continue block38;
                }
                case '2': {
                    ++unicodeLength;
                    continue block38;
                }
                case '3': {
                    ++unicodeLength;
                    continue block38;
                }
                case '4': {
                    ++unicodeLength;
                    continue block38;
                }
                case '5': {
                    ++unicodeLength;
                    continue block38;
                }
                case '6': {
                    ++unicodeLength;
                    continue block38;
                }
                case '7': {
                    ++unicodeLength;
                    continue block38;
                }
                case '8': {
                    ++unicodeLength;
                    continue block38;
                }
                case '9': {
                    ++unicodeLength;
                    continue block38;
                }
                case ':': {
                    ++unicodeLength;
                    continue block38;
                }
                case ';': {
                    ++unicodeLength;
                    continue block38;
                }
                case '<': {
                    return -1;
                }
                case '=': {
                    ++unicodeLength;
                    continue block38;
                }
                case '>': {
                    return -1;
                }
                default: {
                    if (c >= '\ud800' && c <= '\udbff') continue block38;
                    ++unicodeLength;
                }
            }
        }
        return unicodeLength;
    }
}

