/*
 * Decompiled with CFR 0.152.
 */
package protostream.com.squareup.protoparser;

import protostream.com.squareup.protoparser.AutoValue_ExtensionsElement;
import protostream.com.squareup.protoparser.ProtoFile;
import protostream.com.squareup.protoparser.Utils;

public abstract class ExtensionsElement {
    public static ExtensionsElement create(int start, int end) {
        return ExtensionsElement.create(start, end, "");
    }

    public static ExtensionsElement create(int start, int end, String documentation) {
        Utils.checkArgument(ProtoFile.isValidTag(start), "Invalid start value: %s", start);
        Utils.checkArgument(ProtoFile.isValidTag(end), "Invalid end value: %s", end);
        return new AutoValue_ExtensionsElement(documentation, start, end);
    }

    ExtensionsElement() {
    }

    public abstract String documentation();

    public abstract int start();

    public abstract int end();

    public final String toSchema() {
        StringBuilder builder = new StringBuilder();
        Utils.appendDocumentation(builder, this.documentation());
        builder.append("extensions ").append(this.start());
        if (this.start() != this.end()) {
            builder.append(" to ");
            if (this.end() < 0x1FFFFFFF) {
                builder.append(this.end());
            } else {
                builder.append("max");
            }
        }
        return builder.append(";\n").toString();
    }
}

