/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n.verifier;

import ch.qos.cal10n.util.AnnotationExtractor;
import ch.qos.cal10n.util.CAL10NBundle;
import ch.qos.cal10n.util.CAL10NBundleFinder;
import ch.qos.cal10n.util.MiscUtil;
import ch.qos.cal10n.verifier.Cal10nError;
import ch.qos.cal10n.verifier.ErrorFactory;
import ch.qos.cal10n.verifier.IMessageKeyVerifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;

public abstract class AbstractMessageKeyVerifier
implements IMessageKeyVerifier {
    final String enumTypeAsStr;
    final AnnotationExtractor annotationExtractor;

    protected AbstractMessageKeyVerifier(String enumTypeAsStr, AnnotationExtractor annotationExtractor) {
        this.enumTypeAsStr = enumTypeAsStr;
        this.annotationExtractor = annotationExtractor;
    }

    @Override
    public String getEnumTypeAsStr() {
        return this.enumTypeAsStr;
    }

    protected String extractCharsetForLocale(Locale locale) {
        return this.annotationExtractor.extractCharset(locale);
    }

    protected abstract List<String> extractKeysInEnum();

    @Override
    public String[] getLocaleNames() {
        String[] localeNameArray = this.annotationExtractor.extractLocaleNames();
        return localeNameArray;
    }

    @Override
    public String getBaseName() {
        String rbName = this.annotationExtractor.getBaseName();
        return rbName;
    }

    @Override
    public List<Cal10nError> verify(Locale locale) {
        ArrayList<Cal10nError> errorList = new ArrayList<Cal10nError>();
        String baseName = this.getBaseName();
        if (baseName == null) {
            errorList.add(new Cal10nError(Cal10nError.ErrorType.MISSING_BN_ANNOTATION, "", this.enumTypeAsStr, locale, ""));
            return errorList;
        }
        String charset = this.extractCharsetForLocale(locale);
        CAL10NBundleFinder cal10NResourceCAL10NBundleFinder = this.getResourceBundleFinder();
        CAL10NBundle rb = cal10NResourceCAL10NBundleFinder.getBundle(baseName, locale, charset);
        ErrorFactory errorFactory = new ErrorFactory(this.enumTypeAsStr, locale, baseName);
        if (rb == null) {
            errorList.add(errorFactory.buildError(Cal10nError.ErrorType.FAILED_TO_FIND_RB, ""));
            return errorList;
        }
        Set<String> rbKeySet = this.buildKeySetFromEnumeration(((ResourceBundle)rb).getKeys());
        if (rbKeySet.size() == 0) {
            errorList.add(errorFactory.buildError(Cal10nError.ErrorType.EMPTY_RB, ""));
        }
        if (errorList.size() != 0) {
            return errorList;
        }
        List<String> enumKeys = this.extractKeysInEnum();
        if (enumKeys.size() == 0) {
            errorList.add(errorFactory.buildError(Cal10nError.ErrorType.EMPTY_ENUM, ""));
        }
        for (String enumKey : enumKeys) {
            if (rbKeySet.contains(enumKey)) {
                rbKeySet.remove(enumKey);
                continue;
            }
            errorList.add(errorFactory.buildError(Cal10nError.ErrorType.ABSENT_IN_RB, enumKey));
        }
        for (String rbKey : rbKeySet) {
            errorList.add(errorFactory.buildError(Cal10nError.ErrorType.ABSENT_IN_ENUM, rbKey));
        }
        return errorList;
    }

    protected abstract CAL10NBundleFinder getResourceBundleFinder();

    @Override
    public List<String> typeIsolatedVerify(Locale locale) {
        List<Cal10nError> errorList = this.verify(locale);
        ArrayList<String> strList = new ArrayList<String>();
        for (Cal10nError error : errorList) {
            strList.add(error.toString());
        }
        return strList;
    }

    protected Set<String> buildKeySetFromEnumeration(Enumeration<String> e) {
        HashSet<String> set = new HashSet<String>();
        while (e.hasMoreElements()) {
            String s = e.nextElement();
            set.add(s);
        }
        return set;
    }

    @Override
    public List<Cal10nError> verifyAllLocales() {
        ArrayList<Cal10nError> errorList = new ArrayList<Cal10nError>();
        String[] localeNameArray = this.getLocaleNames();
        ErrorFactory errorFactory = new ErrorFactory(this.enumTypeAsStr, null, this.getBaseName());
        if (localeNameArray == null || localeNameArray.length == 0) {
            errorList.add(errorFactory.buildError(Cal10nError.ErrorType.MISSING_LOCALE_DATA_ANNOTATION, "*"));
            return errorList;
        }
        for (String localeName : localeNameArray) {
            Locale locale = MiscUtil.toLocale(localeName);
            List<Cal10nError> tmpList = this.verify(locale);
            errorList.addAll(tmpList);
        }
        return errorList;
    }
}

