/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.adduser;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.domain.management.security.adduser.AddUser;
import org.jboss.as.domain.management.security.adduser.RuntimeOptions;

public class StateValues {
    private final RuntimeOptions options;
    private AddUser.Interactiveness howInteractive = AddUser.Interactiveness.INTERACTIVE;
    private AddUser.RealmMode realmMode = AddUser.RealmMode.DEFAULT;
    private String realm;
    private String userName;
    private String password;
    private AddUser.FileMode fileMode = AddUser.FileMode.UNDEFINED;
    private String groups;
    private boolean existingUser = false;
    private List<File> userFiles;
    private List<File> groupFiles;
    private Set<String> enabledKnownUsers = new HashSet<String>();
    private Set<String> disabledKnownUsers = new HashSet<String>();
    private Map<String, String> knownGroups;
    private boolean displaySecret = false;

    public StateValues() {
        this.options = new RuntimeOptions();
    }

    public StateValues(RuntimeOptions options) {
        this.options = options;
    }

    public boolean isSilentOrNonInteractive() {
        return this.howInteractive == AddUser.Interactiveness.NON_INTERACTIVE || this.isSilent();
    }

    public void setHowInteractive(AddUser.Interactiveness howInteractive) {
        this.howInteractive = howInteractive;
    }

    public boolean isSilent() {
        return this.howInteractive == AddUser.Interactiveness.SILENT;
    }

    public boolean isInteractive() {
        return this.howInteractive == AddUser.Interactiveness.INTERACTIVE;
    }

    public boolean isExistingUser() {
        return this.existingUser;
    }

    public void setExistingUser(boolean existingUser) {
        this.existingUser = existingUser;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public AddUser.RealmMode getRealmMode() {
        return this.realmMode;
    }

    public void setRealmMode(AddUser.RealmMode realmMode) {
        this.realmMode = realmMode;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public AddUser.FileMode getFileMode() {
        return this.fileMode;
    }

    public void setFileMode(AddUser.FileMode fileMode) {
        this.fileMode = fileMode;
    }

    public String getGroups() {
        return this.groups;
    }

    public void setGroups(String groups) {
        this.groups = groups;
    }

    public List<File> getUserFiles() {
        return this.userFiles;
    }

    public void setUserFiles(List<File> userFiles) {
        this.userFiles = userFiles;
    }

    public List<File> getGroupFiles() {
        return this.groupFiles;
    }

    public void setGroupFiles(List<File> groupFiles) {
        this.groupFiles = groupFiles;
    }

    public boolean groupPropertiesFound() {
        return this.groupFiles != null && this.groupFiles.size() > 0;
    }

    public Set<String> getEnabledKnownUsers() {
        return this.enabledKnownUsers;
    }

    public void setEnabledKnownUsers(Set<String> enabledKnownUsers) {
        this.enabledKnownUsers = enabledKnownUsers;
    }

    public Set<String> getDisabledKnownUsers() {
        return this.disabledKnownUsers;
    }

    public void setDisabledKnownUsers(Set<String> disabledKnownUsers) {
        this.disabledKnownUsers = disabledKnownUsers;
    }

    public boolean isExistingEnabledUser() {
        return this.getEnabledKnownUsers().contains(this.getUserName());
    }

    public boolean isExistingDisabledUser() {
        return this.getDisabledKnownUsers().contains(this.getUserName());
    }

    public Map<String, String> getKnownGroups() {
        return this.knownGroups;
    }

    public void setKnownGroups(Map<String, String> knownGroups) {
        this.knownGroups = knownGroups;
    }

    public RuntimeOptions getOptions() {
        return this.options;
    }

    public boolean isDisplaySecret() {
        return this.displaySecret || this.options.isDisplaySecret();
    }

    public void setDisplaySecret(boolean displaySecret) {
        this.displaySecret = displaySecret;
    }
}

