/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.management.impl;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.jboss.JBossServerConfiguration;
import org.jboss.migration.wfly10.WildFlyServer10;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.ManagementOperationException;
import org.jboss.migration.wfly10.config.management.PathResource;
import org.jboss.migration.wfly10.config.management.impl.AbstractManageableResource;
import org.jboss.migration.wfly10.config.management.impl.ExtensionResourceImpl;
import org.jboss.migration.wfly10.config.management.impl.InterfaceResourceImpl;
import org.jboss.migration.wfly10.config.management.impl.PathResourceImpl;
import org.jboss.migration.wfly10.config.management.impl.SocketBindingGroupResourceImpl;
import org.jboss.migration.wfly10.config.management.impl.SystemPropertyResourceImpl;

public abstract class AbstractManageableServerConfiguration
extends AbstractManageableResource
implements ManageableServerConfiguration {
    private final JBossServerConfiguration configurationPath;
    private final WildFlyServer10 server;
    private ModelControllerClient modelControllerClient;
    private final ExtensionResourceImpl.Factory extensionConfigurations;
    private final InterfaceResourceImpl.Factory interfaceResources;
    private final PathResourceImpl.Factory pathResources;
    private final SocketBindingGroupResourceImpl.Factory socketBindingGroupResources;
    private final SystemPropertyResourceImpl.Factory systemPropertyResources;

    protected AbstractManageableServerConfiguration(String resourceName, PathAddress pathAddress, JBossServerConfiguration configurationPath, WildFlyServer10 server) {
        super(resourceName, pathAddress, null);
        this.server = server;
        this.configurationPath = configurationPath;
        this.extensionConfigurations = new ExtensionResourceImpl.Factory(pathAddress, this);
        this.interfaceResources = new InterfaceResourceImpl.Factory(pathAddress, this);
        this.pathResources = new PathResourceImpl.Factory(pathAddress, this);
        this.socketBindingGroupResources = new SocketBindingGroupResourceImpl.Factory(pathAddress, this);
        this.systemPropertyResources = new SystemPropertyResourceImpl.Factory(pathAddress, this);
        this.addChildResourceFactory(this.extensionConfigurations);
        this.addChildResourceFactory(this.interfaceResources);
        this.addChildResourceFactory(this.pathResources);
        this.addChildResourceFactory(this.socketBindingGroupResources);
        this.addChildResourceFactory(this.systemPropertyResources);
    }

    @Override
    public void start() {
        if (this.isStarted()) {
            throw new IllegalStateException("server started");
        }
        this.modelControllerClient = this.startConfiguration();
    }

    protected abstract ModelControllerClient startConfiguration();

    @Override
    public void stop() {
        if (!this.isStarted()) {
            throw new IllegalStateException("server not started");
        }
        this.stopConfiguration();
        this.modelControllerClient = null;
    }

    protected abstract void stopConfiguration();

    @Override
    public boolean isStarted() {
        return this.modelControllerClient != null;
    }

    @Override
    public JBossServerConfiguration getConfigurationPath() {
        return this.configurationPath;
    }

    @Override
    public WildFlyServer10 getServer() {
        return this.server;
    }

    protected void processResult(ModelNode result) throws ManagementOperationException {
        if (!"success".equals(result.get("outcome").asString())) {
            throw new ManagementOperationException(result.get("failure-description").asString());
        }
    }

    @Override
    public ModelNode executeManagementOperation(ModelNode operation) throws ManagementOperationException {
        ModelControllerClient modelControllerClient = this.getModelControllerClient();
        if (modelControllerClient == null) {
            throw new IllegalStateException("configuration not started");
        }
        try {
            ModelNode result = modelControllerClient.execute(operation);
            this.processResult(result);
            return result;
        }
        catch (IOException e) {
            throw new ManagementOperationException(e);
        }
    }

    @Override
    public Path resolvePath(String pathName) throws ManagementOperationException {
        Path resolvedByServer = this.server.resolvePath(pathName);
        if (resolvedByServer != null) {
            return resolvedByServer;
        }
        PathResource resource = this.getPathResource(pathName);
        if (resource != null) {
            ModelNode resourceConfig = resource.getResourceConfiguration();
            String path = resourceConfig.get("path").asString();
            if (resourceConfig.hasDefined("relative-to")) {
                return this.resolvePath(resourceConfig.get("relative-to").asString()).resolve(path);
            }
            return Paths.get(path, new String[0]);
        }
        return null;
    }

    @Override
    public ModelControllerClient getModelControllerClient() {
        return this.modelControllerClient;
    }

    protected void writeConfiguration() {
        String systemPropertyName = "org.jboss.migration.tmp." + System.nanoTime();
        PathAddress pathAddress = this.getSystemPropertyResourcePathAddress(systemPropertyName);
        this.executeManagementOperation(Util.createAddOperation((PathAddress)pathAddress));
        this.executeManagementOperation(Util.createRemoveOperation((PathAddress)pathAddress));
    }
}

