/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.hostexclude;

import java.util.Set;
import org.jboss.migration.core.jboss.HostExclude;
import org.jboss.migration.core.jboss.HostExcludes;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.component.TaskSkipPolicy;
import org.jboss.migration.wfly10.config.management.HostExcludeResource;
import org.jboss.migration.wfly10.config.task.hostexclude.AddHostExclude;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationCompositeSubtasks;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationCompositeTask;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceLeafTask;

public class AddHostExcludes<S>
extends ManageableServerConfigurationCompositeTask.Builder<S> {
    public AddHostExcludes(HostExcludes hostExcludes) {
        this.name("host-excludes.add");
        this.skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet());
        this.beforeRun(context -> context.getLogger().debug((Object)"Adding host-excludes configuration..."));
        ManageableServerConfigurationCompositeSubtasks.Builder subtasksBuilder = new ManageableServerConfigurationCompositeSubtasks.Builder();
        subtasksBuilder.subtask(HostExcludeResource.Parent.class, new RemoveAllHostExclude());
        for (HostExclude hostExclude : hostExcludes.getHostExcludes()) {
            subtasksBuilder.subtask(HostExcludeResource.Parent.class, new AddHostExclude(hostExclude));
        }
        this.subtasks(subtasksBuilder);
        this.afterRun(context -> {
            if (context.hasSucessfulSubtasks()) {
                context.getLogger().info((Object)"Host-excludes configuration added.");
            } else {
                context.getLogger().debug((Object)"Host-excludes configuration not added.");
            }
        });
    }

    private static class RemoveAllHostExclude<S>
    extends ManageableResourceLeafTask.Builder<S, HostExcludeResource.Parent> {
        public RemoveAllHostExclude() {
            this.name("host-exclude.removeAll");
            this.skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet());
            this.beforeRun(context -> context.getLogger().debugf("Removing all legacy host-exclude configs...", new Object[0]));
            this.runBuilder(params -> taskContext -> {
                HostExcludeResource.Parent parent = (HostExcludeResource.Parent)params.getResource();
                Set<String> legacyHostExcludeNames = parent.getHostExcludeResourceNames();
                if (legacyHostExcludeNames.isEmpty()) {
                    taskContext.getLogger().debugf("No legacy host-exclude configs found.", new Object[0]);
                    return ServerMigrationTaskResult.SKIPPED;
                }
                for (String hostExcludeName : legacyHostExcludeNames) {
                    parent.removeHostExcludeResource(hostExcludeName);
                    taskContext.getLogger().debugf("Legacy host-exclude %s found and removed.", (Object)hostExcludeName);
                }
                taskContext.getLogger().debugf("All legacy host-exclude configs removed.", new Object[0]);
                return ServerMigrationTaskResult.SUCCESS;
            });
        }
    }
}

