/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.module;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import javax.xml.stream.XMLStreamReader;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.core.jboss.ModulesMigrationTask;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.config.task.module.ConfigurationModulesMigrationTaskFactory;

public class ExtensionModulesFinder
implements ConfigurationModulesMigrationTaskFactory.ModulesFinder {
    @Override
    public String getElementLocalName() {
        return "extension";
    }

    @Override
    public void processElement(XMLStreamReader reader, ModulesMigrationTask.ModuleMigrator moduleMigrator, TaskContext context) throws IOException {
        String namespaceURI = reader.getNamespaceURI();
        if (namespaceURI == null || !namespaceURI.startsWith("urn:jboss:domain:")) {
            return;
        }
        String moduleId = reader.getAttributeValue(null, "module");
        if (moduleId != null) {
            HashSet accepted = new HashSet(moduleMigrator.getTargetServer().getExtensions().getExtensionModuleNames());
            MigrationEnvironment environment = context.getMigrationEnvironment();
            accepted.addAll(environment.getPropertyAsList("extensions.includes", Collections.emptyList()));
            accepted.removeAll(environment.getPropertyAsList("extensions.excludes", Collections.emptyList()));
            if (accepted.contains(moduleId)) {
                moduleMigrator.migrateModule(moduleId, "Required by Extension", context);
            }
        }
    }
}

