/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.task;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ServerMigrationTaskName
implements Serializable {
    private static final Map<String, String> NO_ATTRIBUTES = Collections.unmodifiableMap(new HashMap());
    private final String name;
    private final Map<String, String> attributes;

    private ServerMigrationTaskName(String name, Map<String, String> attributes) {
        this.name = name;
        this.attributes = attributes != null ? Collections.unmodifiableMap(attributes) : NO_ATTRIBUTES;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        if (!this.attributes.isEmpty()) {
            sb.append("(");
            boolean first = true;
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(entry.getKey());
                sb.append('=');
                sb.append(entry.getValue());
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public static class Builder {
        private final String name;
        private Map<String, String> attributes;

        public Builder(String name) {
            this.name = name;
        }

        public Builder(ServerMigrationTaskName taskName) {
            this(taskName.name);
            if (!taskName.getAttributes().isEmpty()) {
                this.attributes = new HashMap<String, String>(taskName.getAttributes());
            }
        }

        public Builder addAttribute(String name, String value) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, String>();
            }
            this.attributes.put(name, value);
            return this;
        }

        public ServerMigrationTaskName build() {
            return new ServerMigrationTaskName(this.name, this.attributes);
        }
    }
}

