/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.util.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.migration.core.util.xml.Node;

public class ProcessingInstructionNode
extends Node {
    private final String name;
    private final Map<String, String> data;
    private List<Node> delegates = new ArrayList<Node>();

    public ProcessingInstructionNode(String name, Map<String, String> data) {
        this.name = name;
        this.data = data;
    }

    public void addDelegate(Node delegate) {
        if (delegate != null) {
            this.delegates.add(delegate);
        }
    }

    public String getDataValue(String name, String defaultValue) {
        String s;
        if (this.data != null && (s = this.data.get(name)) != null) {
            return s;
        }
        return defaultValue;
    }

    @Override
    public void marshall(XMLStreamWriter writer) throws XMLStreamException {
        for (Node delegate : this.delegates) {
            delegate.marshall(writer);
        }
    }

    @Override
    public boolean hasContent() {
        for (Node delegate : this.delegates) {
            if (!delegate.hasContent()) continue;
            return true;
        }
        return false;
    }
}

