/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.wst11.messaging;

import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices.SoapFaultType;
import com.arjuna.webservices.base.processors.ActivatedObjectProcessor;
import com.arjuna.webservices.logging.WSTLogger;
import com.arjuna.webservices11.SoapFault11;
import com.arjuna.webservices11.wsaddr.AddressingHelper;
import com.arjuna.webservices11.wsarj.ArjunaContext;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsba.ParticipantCompletionParticipantInboundEvents;
import com.arjuna.webservices11.wsba.client.ParticipantCompletionCoordinatorClient;
import com.arjuna.webservices11.wsba.processors.ParticipantCompletionParticipantProcessor;
import com.arjuna.webservices11.wscoor.CoordinationConstants;
import com.arjuna.wsc11.messaging.MessageId;
import org.jboss.jbossts.xts.recovery.participant.ba.XTSBARecoveryManager;
import org.jboss.ws.api.addressing.MAP;
import org.oasis_open.docs.ws_tx.wsba._2006._06.NotificationType;
import org.oasis_open.docs.ws_tx.wsba._2006._06.StatusType;

public class ParticipantCompletionParticipantProcessorImpl
extends ParticipantCompletionParticipantProcessor {
    private final ActivatedObjectProcessor activatedObjectProcessor = new ActivatedObjectProcessor();

    @Override
    public void activateParticipant(ParticipantCompletionParticipantInboundEvents participant, String identifier) {
        this.activatedObjectProcessor.activateObject(participant, identifier);
    }

    @Override
    public void deactivateParticipant(ParticipantCompletionParticipantInboundEvents participant) {
        this.activatedObjectProcessor.deactivateObject(participant);
    }

    @Override
    public boolean isActive(String identifier) {
        return this.activatedObjectProcessor.getObject(identifier) != null;
    }

    private ParticipantCompletionParticipantInboundEvents getParticipant(InstanceIdentifier instanceIdentifier) {
        String identifier = instanceIdentifier != null ? instanceIdentifier.getInstanceIdentifier() : null;
        return (ParticipantCompletionParticipantInboundEvents)this.activatedObjectProcessor.getObject(identifier);
    }

    @Override
    public void cancel(NotificationType cancel, MAP map, ArjunaContext arjunaContext) {
        InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
        XTSBARecoveryManager recoveryManager = XTSBARecoveryManager.getRecoveryManager();
        if (recoveryManager == null) {
            WSTLogger.i18NLogger.warn_wst11_messaging_ParticipantCompletionParticipantProcessorImpl_cancel_3(instanceIdentifier.toString());
            return;
        }
        ParticipantCompletionParticipantInboundEvents participant = this.getParticipant(instanceIdentifier);
        if (participant != null) {
            try {
                participant.cancel(cancel, map, arjunaContext);
            }
            catch (Throwable th) {
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("Unexpected exception thrown from cancel:", (Object)th);
                }
            }
        } else if (!recoveryManager.isParticipantRecoveryStarted()) {
            WSTLogger.i18NLogger.warn_wst11_messaging_ParticipantCompletionParticipantProcessorImpl_cancel_4(instanceIdentifier.toString());
        } else if (recoveryManager.findParticipantRecoveryRecord(instanceIdentifier.getInstanceIdentifier()) != null) {
            WSTLogger.i18NLogger.warn_wst11_messaging_ParticipantCompletionParticipantProcessorImpl_cancel_5(instanceIdentifier.toString());
        } else {
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.tracev("Cancel called on unknown participant: {0}", new Object[]{instanceIdentifier});
            }
            this.sendCancelled(map, arjunaContext);
        }
    }

    @Override
    public void close(NotificationType close, MAP map, ArjunaContext arjunaContext) {
        InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
        XTSBARecoveryManager recoveryManager = XTSBARecoveryManager.getRecoveryManager();
        if (recoveryManager == null) {
            WSTLogger.i18NLogger.warn_wst11_messaging_ParticipantCompletionParticipantProcessorImpl_close_3(instanceIdentifier.toString());
            return;
        }
        ParticipantCompletionParticipantInboundEvents participant = this.getParticipant(instanceIdentifier);
        if (participant != null) {
            try {
                participant.close(close, map, arjunaContext);
            }
            catch (Throwable th) {
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("Unexpected exception thrown from close:", (Object)th);
                }
            }
        } else if (!recoveryManager.isParticipantRecoveryStarted()) {
            WSTLogger.i18NLogger.warn_wst11_messaging_ParticipantCompletionParticipantProcessorImpl_close_4(instanceIdentifier.toString());
        } else if (recoveryManager.findParticipantRecoveryRecord(instanceIdentifier.getInstanceIdentifier()) != null) {
            WSTLogger.i18NLogger.warn_wst11_messaging_ParticipantCompletionParticipantProcessorImpl_close_5(instanceIdentifier.toString());
        } else {
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.tracev("Close called on unknown participant: {0}", new Object[]{instanceIdentifier});
            }
            this.sendClosed(map, arjunaContext);
        }
    }

    @Override
    public void compensate(NotificationType compensate, MAP map, ArjunaContext arjunaContext) {
        InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
        XTSBARecoveryManager recoveryManager = XTSBARecoveryManager.getRecoveryManager();
        if (recoveryManager == null) {
            WSTLogger.i18NLogger.warn_wst11_messaging_ParticipantCompletionParticipantProcessorImpl_compensate_3(instanceIdentifier.toString());
            return;
        }
        ParticipantCompletionParticipantInboundEvents participant = this.getParticipant(instanceIdentifier);
        if (participant != null) {
            try {
                participant.compensate(compensate, map, arjunaContext);
            }
            catch (Throwable th) {
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("Unexpected exception thrown from compensate:", (Object)th);
                }
            }
        } else if (!recoveryManager.isParticipantRecoveryStarted()) {
            WSTLogger.i18NLogger.warn_wst11_messaging_ParticipantCompletionParticipantProcessorImpl_compensate_4(instanceIdentifier.toString());
        } else if (recoveryManager.findParticipantRecoveryRecord(instanceIdentifier.getInstanceIdentifier()) != null) {
            WSTLogger.i18NLogger.warn_wst11_messaging_ParticipantCompletionParticipantProcessorImpl_compensate_5(instanceIdentifier.toString());
        } else {
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.tracev("Compensate called on unknown participant: {0}", new Object[]{instanceIdentifier});
            }
            this.sendCompensated(map, arjunaContext);
        }
    }

    @Override
    public void exited(NotificationType exited, MAP map, ArjunaContext arjunaContext) {
        InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
        ParticipantCompletionParticipantInboundEvents participant = this.getParticipant(instanceIdentifier);
        if (participant != null) {
            try {
                participant.exited(exited, map, arjunaContext);
            }
            catch (Throwable th) {
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("Unexpected exception thrown from exited:", (Object)th);
                }
            }
        } else if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.tracev("Exited called on unknown participant: {0}", new Object[]{instanceIdentifier});
        }
    }

    @Override
    public void notCompleted(NotificationType notCompleted, MAP map, ArjunaContext arjunaContext) {
        InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
        ParticipantCompletionParticipantInboundEvents participant = this.getParticipant(instanceIdentifier);
        if (participant != null) {
            try {
                participant.notCompleted(notCompleted, map, arjunaContext);
            }
            catch (Throwable th) {
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("Unexpected exception thrown from notCompleted:", (Object)th);
                }
            }
        } else if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.tracev("Exited called on unknown participant: {0}", new Object[]{instanceIdentifier});
        }
    }

    @Override
    public void failed(NotificationType failed, MAP map, ArjunaContext arjunaContext) {
        InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
        ParticipantCompletionParticipantInboundEvents participant = this.getParticipant(instanceIdentifier);
        if (participant != null) {
            try {
                participant.failed(failed, map, arjunaContext);
            }
            catch (Throwable th) {
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("Unexpected exception thrown from failed:", (Object)th);
                }
            }
        } else if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.tracev("Failed called on unknown participant: {0}", new Object[]{instanceIdentifier});
        }
    }

    @Override
    public void getStatus(NotificationType getStatus, MAP map, ArjunaContext arjunaContext) {
        block7: {
            InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
            ParticipantCompletionParticipantInboundEvents participant = this.getParticipant(instanceIdentifier);
            if (participant != null) {
                try {
                    participant.getStatus(getStatus, map, arjunaContext);
                }
                catch (Throwable th) {
                    if (WSTLogger.logger.isTraceEnabled()) {
                        WSTLogger.logger.tracev("Unexpected exception thrown from getStatus:", (Object)th);
                    }
                    break block7;
                }
            }
            if (WSTLogger.logger.isTraceEnabled()) {
                WSTLogger.logger.tracev("GetStatus called on unknown participant: {0}", new Object[]{instanceIdentifier});
            }
            String messageId = MessageId.getMessageId();
            MAP faultMAP = AddressingHelper.createFaultContext(map, messageId);
            try {
                SoapFault11 soapFault = new SoapFault11(SoapFaultType.FAULT_SENDER, CoordinationConstants.WSCOOR_ERROR_CODE_INVALID_STATE_QNAME, WSTLogger.i18NLogger.get_wst11_messaging_ParticipantCompletionParticipantProcessorImpl_getStatus_4());
                ParticipantCompletionCoordinatorClient.getClient().sendSoapFault(soapFault, null, faultMAP, ParticipantCompletionParticipantProcessorImpl.getFaultAction());
            }
            catch (Throwable th) {
                WSTLogger.i18NLogger.info_wst11_messaging_ParticipantCompletionParticipantProcessorImpl_getStatus_3(instanceIdentifier.toString(), th);
            }
        }
    }

    private static String getFaultAction() {
        return "http://docs.oasis-open.org/ws-tx/wscoor/2006/06/fault";
    }

    @Override
    public void status(StatusType status, MAP map, ArjunaContext arjunaContext) {
        InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
        ParticipantCompletionParticipantInboundEvents participant = this.getParticipant(instanceIdentifier);
        if (participant != null) {
            try {
                participant.status(status, map, arjunaContext);
            }
            catch (Throwable th) {
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("Unexpected exception thrown from status:", (Object)th);
                }
            }
        } else if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.tracev("Status called on unknown participant: {0}", new Object[]{instanceIdentifier});
        }
    }

    @Override
    public void soapFault(SoapFault fault, MAP map, ArjunaContext arjunaContext) {
        InstanceIdentifier instanceIdentifier = arjunaContext.getInstanceIdentifier();
        ParticipantCompletionParticipantInboundEvents participant = this.getParticipant(instanceIdentifier);
        if (participant != null) {
            try {
                participant.soapFault(fault, map, arjunaContext);
            }
            catch (Throwable th) {
                if (WSTLogger.logger.isTraceEnabled()) {
                    WSTLogger.logger.tracev("Unexpected exception thrown from soapFault:", (Object)th);
                }
            }
        } else if (WSTLogger.logger.isTraceEnabled()) {
            WSTLogger.logger.tracev("SoapFault called on unknown participant: {0}", new Object[]{instanceIdentifier});
        }
    }

    private void sendCancelled(MAP map, ArjunaContext arjunaContext) {
        block2: {
            String messageId = MessageId.getMessageId();
            MAP responseMAP = AddressingHelper.createOneWayResponseContext(map, messageId);
            try {
                ParticipantCompletionCoordinatorClient.getClient().sendCancelled(null, responseMAP, arjunaContext.getInstanceIdentifier());
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending Cancelled", (Object)th);
            }
        }
    }

    private void sendClosed(MAP map, ArjunaContext arjunaContext) {
        block2: {
            String messageId = MessageId.getMessageId();
            MAP responseMAP = AddressingHelper.createOneWayResponseContext(map, messageId);
            try {
                ParticipantCompletionCoordinatorClient.getClient().sendClosed(null, responseMAP, arjunaContext.getInstanceIdentifier());
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending Closed", (Object)th);
            }
        }
    }

    private void sendCompensated(MAP map, ArjunaContext arjunaContext) {
        block2: {
            String messageId = MessageId.getMessageId();
            MAP responseMAP = AddressingHelper.createOneWayResponseContext(map, messageId);
            try {
                ParticipantCompletionCoordinatorClient.getClient().sendCompensated(null, responseMAP, arjunaContext.getInstanceIdentifier());
            }
            catch (Throwable th) {
                if (!WSTLogger.logger.isTraceEnabled()) break block2;
                WSTLogger.logger.tracev("Unexpected exception while sending Compensated", (Object)th);
            }
        }
    }
}

