/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.examples;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientId;
import org.bouncycastle.mail.smime.SMIMEEnvelopedParser;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.bouncycastle.mail.smime.examples.ExampleUtils;
import org.bouncycastle.mail.smime.util.FileBackedMimeBodyPart;
import org.bouncycastle.mail.smime.util.SharedFileInputStream;

public class ReadLargeEncryptedMail {
    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.err.println("usage: ReadLargeEncryptedMail pkcs12Keystore password outputFile");
            System.exit(0);
        }
        KeyStore ks = KeyStore.getInstance("PKCS12", "BC");
        String keyAlias = ExampleUtils.findKeyAlias(ks, args[0], args[1].toCharArray());
        X509Certificate cert = (X509Certificate)ks.getCertificate(keyAlias);
        JceKeyTransRecipientId recId = new JceKeyTransRecipientId(cert);
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        MimeMessage msg = new MimeMessage(session, (InputStream)new SharedFileInputStream("encrypted.message"));
        SMIMEEnvelopedParser m = new SMIMEEnvelopedParser(msg);
        RecipientInformationStore recipients = m.getRecipientInfos();
        RecipientInformation recipient = recipients.get((RecipientId)recId);
        FileBackedMimeBodyPart res = SMIMEUtil.toMimeBodyPart(recipient.getContentStream((Recipient)new JceKeyTransEnvelopedRecipient((PrivateKey)ks.getKey(keyAlias, null)).setProvider("BC")));
        ExampleUtils.dumpContent(res, args[2]);
    }
}

