/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.txframework.impl.handlers.wsba;

import com.arjuna.mw.wst11.BusinessActivityManager;
import com.arjuna.mw.wst11.BusinessActivityManagerFactory;
import com.arjuna.wst.BusinessAgreementWithCoordinatorCompletionParticipant;
import com.arjuna.wst.BusinessAgreementWithParticipantCompletionParticipant;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.UnknownTransactionException;
import com.arjuna.wst.WrongStateException;
import com.arjuna.wst11.BAParticipantManager;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.UUID;
import org.jboss.narayana.txframework.api.annotation.lifecycle.ba.Completes;
import org.jboss.narayana.txframework.api.configuration.transaction.CompletionType;
import org.jboss.narayana.txframework.api.exception.TXFrameworkException;
import org.jboss.narayana.txframework.api.management.WSBATxControl;
import org.jboss.narayana.txframework.impl.Participant;
import org.jboss.narayana.txframework.impl.ServiceInvocationMeta;
import org.jboss.narayana.txframework.impl.handlers.ParticipantRegistrationException;
import org.jboss.narayana.txframework.impl.handlers.ProtocolHandler;
import org.jboss.narayana.txframework.impl.handlers.wsba.WSBACoordinatorCompletionParticipant;
import org.jboss.narayana.txframework.impl.handlers.wsba.WSBAParticipantCompletionParticipant;
import org.jboss.narayana.txframework.impl.handlers.wsba.WSBATxControlImpl;

public class WSBAHandler
implements ProtocolHandler {
    private ServiceInvocationMeta serviceInvocationMeta;
    private BAParticipantManager participantManager;
    private Participant participant;
    WSBATxControl wsbaTxControl = new WSBATxControlImpl();

    public WSBAHandler(ServiceInvocationMeta serviceInvocationMeta, CompletionType completionType) throws TXFrameworkException {
        this.serviceInvocationMeta = serviceInvocationMeta;
        try {
            BusinessActivityManager businessActivityManager = BusinessActivityManagerFactory.businessActivityManager();
            if (completionType == CompletionType.COORDINATOR) {
                WSBACoordinatorCompletionParticipant coordinatorCompletionParticipant = new WSBACoordinatorCompletionParticipant(serviceInvocationMeta, new HashMap());
                this.participantManager = businessActivityManager.enlistForBusinessAgreementWithCoordinatorCompletion((BusinessAgreementWithCoordinatorCompletionParticipant)coordinatorCompletionParticipant, serviceInvocationMeta.getServiceClass().getName() + UUID.randomUUID());
                this.participant = coordinatorCompletionParticipant;
            } else {
                WSBAParticipantCompletionParticipant participantCompletionParticipant = new WSBAParticipantCompletionParticipant(serviceInvocationMeta, new HashMap());
                this.participantManager = businessActivityManager.enlistForBusinessAgreementWithParticipantCompletion((BusinessAgreementWithParticipantCompletionParticipant)participantCompletionParticipant, serviceInvocationMeta.getServiceClass().getName() + UUID.randomUUID());
                this.participant = participantCompletionParticipant;
            }
        }
        catch (WrongStateException e) {
            throw new ParticipantRegistrationException("Transaction was not in a state in which participants can be registered", e);
        }
        catch (UnknownTransactionException e) {
            throw new ParticipantRegistrationException("Can't register a participant as the transaction in unknown", e);
        }
        catch (SystemException e) {
            throw new ParticipantRegistrationException("A SystemException occurred when attempting to register a participant", e);
        }
        WSBATxControlImpl.resume(this.participantManager);
    }

    @Override
    public void preInvocation() throws Exception {
        WSBATxControlImpl.resume(this.participantManager);
        this.participant.resume();
    }

    @Override
    public void notifySuccess() throws TXFrameworkException {
        if (this.shouldComplete(this.serviceInvocationMeta.getServiceMethod()) && !((WSBATxControlImpl)this.wsbaTxControl).isCannotComplete()) {
            try {
                this.participantManager.completed();
            }
            catch (WrongStateException e) {
                throw new TXFrameworkException("Error notifying completion on participant manager.", e);
            }
            catch (UnknownTransactionException e) {
                throw new TXFrameworkException("Error notifying completion on participant manager.", e);
            }
            catch (SystemException e) {
                throw new TXFrameworkException("Error notifying completion on participant manager.", e);
            }
        }
        Participant.suspend();
        WSBATxControlImpl.suspend();
    }

    @Override
    public void notifyFailure() throws TXFrameworkException {
        try {
            this.participantManager.cannotComplete();
        }
        catch (WrongStateException e) {
            throw new TXFrameworkException("Error notifying cannotComplete on participant manager.", e);
        }
        catch (UnknownTransactionException e) {
            throw new TXFrameworkException("Error notifying cannotComplete on participant manager.", e);
        }
        catch (SystemException e) {
            throw new TXFrameworkException("Error notifying cannotComplete on participant manager.", e);
        }
        Participant.suspend();
        WSBATxControlImpl.suspend();
    }

    private boolean shouldComplete(Method serviceMethod) {
        Completes completes = serviceMethod.getAnnotation(Completes.class);
        return completes != null;
    }
}

