/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.VelocityWriter;
import org.apache.cxf.tools.util.FileWriterUtil;
import org.apache.cxf.version.Version;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public final class VelocityGenerator {
    private static final Logger LOG = LogUtils.getL7dLogger(VelocityGenerator.class);
    private static boolean initialized;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private String baseDir;

    public VelocityGenerator() {
        this(false);
    }

    public VelocityGenerator(boolean log) {
        VelocityGenerator.initVelocity(log);
    }

    private static String getVelocityLogFile(String logfile) {
        String logdir = System.getProperty("user.home");
        if (logdir == null || logdir.length() == 0) {
            logdir = System.getProperty("user.dir");
        }
        return logdir + File.separator + logfile;
    }

    private static synchronized void initVelocity(boolean log) throws ToolException {
        if (initialized) {
            return;
        }
        initialized = true;
        try {
            Properties props = new Properties();
            String clzName = "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader";
            props.put("resource.loaders", "class");
            props.put("resource.loader.class.class", clzName);
            props.put("runtime.log", VelocityGenerator.getVelocityLogFile("velocity.log"));
            if (!log) {
                try {
                    Class<?> nopLoggerClass = Class.forName("org.slf4j.helpers.NOPLogger");
                    Constructor<?> cons1 = nopLoggerClass.getDeclaredConstructor(new Class[0]);
                    cons1.setAccessible(true);
                    props.put("runtime.log.instance", cons1.newInstance(new Object[0]));
                }
                catch (Exception ex) {
                    LOG.log(Level.INFO, ex.getMessage());
                }
            }
            Velocity.init((Properties)props);
        }
        catch (Exception e) {
            Message msg = new Message("FAIL_TO_INITIALIZE_VELOCITY_ENGINE", LOG, new Object[0]);
            LOG.log(Level.SEVERE, msg.toString());
            throw new ToolException(msg, (Throwable)e);
        }
    }

    public void doWrite(String templateName, Writer outputs) throws ToolException {
        Template tmpl = null;
        try {
            tmpl = Velocity.getTemplate((String)templateName);
        }
        catch (Exception e) {
            Message msg = new Message("TEMPLATE_MISSING", LOG, new Object[]{templateName});
            throw new ToolException(msg, (Throwable)e);
        }
        VelocityContext ctx = new VelocityContext();
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            ctx.put(entry.getKey(), entry.getValue());
        }
        VelocityWriter writer = new VelocityWriter(outputs);
        ctx.put("out", (Object)writer);
        try {
            tmpl.merge((Context)ctx, (Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            Message msg = new Message("VELOCITY_ENGINE_WRITE_ERRORS", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)e);
        }
    }

    public void setBaseDir(String dir) {
        this.baseDir = dir;
    }

    public File parseOutputName(String packageName, String filename) throws ToolException {
        return this.parseOutputName(packageName, filename, ".java");
    }

    public File parseOutputName(String packageName, String filename, String ext) throws ToolException {
        FileUtils.mkDir((File)new File(this.baseDir));
        FileWriterUtil fw = new FileWriterUtil(this.baseDir, null);
        try {
            return fw.getFileToWrite(packageName, filename + ext);
        }
        catch (IOException ioe) {
            Message msg = new Message("FAIL_TO_WRITE_FILE", LOG, new Object[]{packageName + "." + filename + ext});
            throw new ToolException(msg, (Throwable)ioe);
        }
    }

    public void setCommonAttributes() {
        this.attributes.put("currentdate", Calendar.getInstance().getTime());
        this.attributes.put("version", Version.getCurrentVersion());
        this.attributes.put("name", Version.getName());
        this.attributes.put("fullversion", Version.getCompleteVersionString());
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public void setAttributes(String n, Object value) {
        this.attributes.put(n, value);
    }
}

