/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.env;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.migration.core.env.Environment;
import org.jboss.migration.core.env.EnvironmentProperty;

public interface EnvironmentProperties {
    public static EnvironmentProperty<Boolean> newBooleanProperty(String name) {
        return EnvironmentProperties.newBooleanProperty(name, null);
    }

    public static EnvironmentProperty<Boolean> newBooleanProperty(String name, Boolean defaultValue) {
        return EnvironmentProperties.newProperty(name, defaultValue, stringValue -> stringValue != null ? Boolean.valueOf(stringValue) : null, tValue -> tValue != null ? tValue.toString() : null);
    }

    public static EnvironmentProperty<Integer> newIntegerProperty(String name) {
        return EnvironmentProperties.newIntegerProperty(name, null);
    }

    public static EnvironmentProperty<Integer> newIntegerProperty(String name, Integer defaultValue) {
        return EnvironmentProperties.newProperty(name, defaultValue, stringValue -> stringValue != null ? Integer.valueOf(stringValue) : null, tValue -> tValue != null ? tValue.toString() : null);
    }

    public static EnvironmentProperty<String> newStringProperty(String name) {
        return EnvironmentProperties.newStringProperty(name, null);
    }

    public static EnvironmentProperty<String> newStringProperty(String name, String defaultValue) {
        return EnvironmentProperties.newProperty(name, defaultValue, stringValue -> stringValue, stringValue -> stringValue);
    }

    public static EnvironmentProperty<Path> newPathProperty(String name) {
        return EnvironmentProperties.newPathProperty(name, null);
    }

    public static EnvironmentProperty<Path> newPathProperty(String name, Path defaultValue) {
        return EnvironmentProperties.newProperty(name, defaultValue, stringValue -> stringValue != null ? Paths.get(stringValue, new String[0]) : null, pathValue -> pathValue != null ? pathValue.toString() : null);
    }

    public static EnvironmentProperty<List<String>> newStringListProperty(String name) {
        return EnvironmentProperties.newStringListProperty(name, null);
    }

    public static EnvironmentProperty<List<String>> newStringListProperty(String name, List<String> defaultValue) {
        return EnvironmentProperties.newListProperty(name, defaultValue, stringValue -> stringValue, stringValue -> stringValue);
    }

    public static <T> EnvironmentProperty<T> newProperty(final String name, final T defaultValue, final Function<String, T> stringToValueMapper, final Function<T, String> valueToStringMapper) {
        return new EnvironmentProperty<T>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public T getValue(Environment environment) {
                String stringValue = environment.getPropertyAsString(this.getName());
                Object tValue = stringValue != null ? (Object)stringToValueMapper.apply(stringValue.trim()) : null;
                return tValue != null ? tValue : defaultValue;
            }

            @Override
            public void setValue(T value, Environment environment) {
                String string = (String)valueToStringMapper.apply(value);
                environment.setProperty(this.getName(), string);
            }
        };
    }

    public static <T> EnvironmentProperty<List<T>> newListProperty(String name, List<T> defaultValue, Function<String, T> stringToValueMapper, Function<T, String> valueToStringMapper) {
        return EnvironmentProperties.newProperty(name, defaultValue, stringValue -> stringValue != null ? Stream.of(stringValue.trim().split(",")).filter(s -> !s.trim().isEmpty()).map(stringToValueMapper).collect(Collectors.toList()) : null, list -> list != null ? list.stream().map(value -> (String)valueToStringMapper.apply(value)).collect(Collectors.joining(", ")) : null);
    }
}

