/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.remoting.ssl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.ServiceLoader;
import javax.net.ssl.SSLContext;
import org.apache.activemq.artemis.spi.core.remoting.ssl.SSLContextFactory;

public class SSLContextFactoryProvider {
    private static final SSLContextFactory factory;

    public static SSLContextFactory getSSLContextFactory() {
        return factory;
    }

    static {
        ServiceLoader<SSLContextFactory> loader = ServiceLoader.load(SSLContextFactory.class, Thread.currentThread().getContextClassLoader());
        ArrayList factories = new ArrayList();
        loader.forEach(factories::add);
        if (factories.isEmpty()) {
            factory = new SSLContextFactory(){

                @Override
                public SSLContext getSSLContext(Map<String, Object> configuration, String keystoreProvider, String keystoreType, String keystorePath, String keystorePassword, String truststoreProvider, String truststoreType, String truststorePath, String truststorePassword, String crlPath, String trustManagerFactoryPlugin, boolean trustAll) throws Exception {
                    return SSLContext.getDefault();
                }

                @Override
                public int getPriority() {
                    return -1;
                }
            };
        } else {
            Collections.sort(factories);
            factory = (SSLContextFactory)factories.get(factories.size() - 1);
        }
    }
}

