/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.mapping.providers.role;

import java.security.Principal;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.Util;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.plugins.SimpleRole;
import org.jboss.security.mapping.providers.role.AbstractRolesMappingProvider;
import org.jboss.security.mapping.providers.role.SecurityActions;
import org.jboss.security.vault.SecurityVaultException;
import org.jboss.security.vault.SecurityVaultUtil;

public class LdapRolesMappingProvider
extends AbstractRolesMappingProvider {
    private static final String BIND_DN = "bindDN";
    private static final String BIND_CREDENTIAL = "bindCredential";
    private static final String ROLES_CTX_DN_OPT = "rolesCtxDN";
    private static final String ROLE_ATTRIBUTE_ID_OPT = "roleAttributeID";
    private static final String ROLE_ATTRIBUTE_IS_DN_OPT = "roleAttributeIsDN";
    private static final String ROLE_NAME_ATTRIBUTE_ID_OPT = "roleNameAttributeID";
    private static final String PARSE_ROLE_NAME_FROM_DN_OPT = "parseRoleNameFromDN";
    private static final String ROLE_FILTER_OPT = "roleFilter";
    private static final String ROLE_RECURSION = "roleRecursion";
    private static final String SEARCH_TIME_LIMIT_OPT = "searchTimeLimit";
    private static final String SEARCH_SCOPE_OPT = "searchScope";
    protected String bindDN;
    protected String bindCredential;
    protected String rolesCtxDN;
    protected String roleFilter;
    protected String roleAttributeID;
    protected String roleNameAttributeID;
    protected boolean roleAttributeIsDN;
    protected boolean parseRoleNameFromDN;
    protected int recursion = 0;
    protected int searchTimeLimit = 10000;
    protected int searchScope = 2;
    protected Map<String, Object> options;

    @Override
    public void init(Map<String, Object> options) {
        if (options != null) {
            String scope;
            this.options = options;
            this.bindDN = (String)options.get(BIND_DN);
            this.bindCredential = (String)options.get(BIND_CREDENTIAL);
            if (this.bindCredential != null && Util.isPasswordCommand(this.bindCredential)) {
                try {
                    this.bindCredential = new String(Util.loadPassword(this.bindCredential));
                }
                catch (Exception e) {
                    throw PicketBoxMessages.MESSAGES.failedToDecodeBindCredential(e);
                }
            }
            if (this.bindCredential != null && SecurityVaultUtil.isVaultFormat(this.bindCredential)) {
                try {
                    this.bindCredential = SecurityVaultUtil.getValueAsString(this.bindCredential);
                }
                catch (SecurityVaultException ve) {
                    throw new IllegalArgumentException(PicketBoxMessages.MESSAGES.unableToGetPasswordFromVault());
                }
            }
            this.roleFilter = (String)options.get(ROLE_FILTER_OPT);
            this.roleAttributeID = (String)options.get(ROLE_ATTRIBUTE_ID_OPT);
            if (this.roleAttributeID == null) {
                this.roleAttributeID = "role";
            }
            String roleAttributeIsDNOption = (String)options.get(ROLE_ATTRIBUTE_IS_DN_OPT);
            this.roleAttributeIsDN = Boolean.valueOf(roleAttributeIsDNOption);
            this.roleNameAttributeID = (String)options.get(ROLE_NAME_ATTRIBUTE_ID_OPT);
            if (this.roleNameAttributeID == null) {
                this.roleNameAttributeID = "name";
            }
            String parseRoleNameFromDNOption = (String)options.get(PARSE_ROLE_NAME_FROM_DN_OPT);
            this.parseRoleNameFromDN = Boolean.valueOf(parseRoleNameFromDNOption);
            this.rolesCtxDN = (String)options.get(ROLES_CTX_DN_OPT);
            String strRecursion = (String)options.get(ROLE_RECURSION);
            try {
                this.recursion = Integer.parseInt(strRecursion);
            }
            catch (Exception e) {
                PicketBoxLogger.LOGGER.debugFailureToParseNumberProperty(ROLE_RECURSION, 0L);
                this.recursion = 0;
            }
            String timeLimit = (String)options.get(SEARCH_TIME_LIMIT_OPT);
            if (timeLimit != null) {
                try {
                    this.searchTimeLimit = Integer.parseInt(timeLimit);
                }
                catch (NumberFormatException e) {
                    PicketBoxLogger.LOGGER.debugFailureToParseNumberProperty(SEARCH_TIME_LIMIT_OPT, this.searchTimeLimit);
                }
            }
            if ("OBJECT_SCOPE".equalsIgnoreCase(scope = (String)options.get(SEARCH_SCOPE_OPT))) {
                this.searchScope = 0;
            } else if ("ONELEVEL_SCOPE".equalsIgnoreCase(scope)) {
                this.searchScope = 1;
            }
            if ("SUBTREE_SCOPE".equalsIgnoreCase(scope)) {
                this.searchScope = 2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performMapping(Map<String, Object> contextMap, RoleGroup mappedObject) {
        if (contextMap == null || contextMap.isEmpty()) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("contextMap");
        }
        Principal principal = this.getCallerPrincipal(contextMap);
        if (principal != null) {
            InitialContext ctx = null;
            ClassLoader currentTCCL = SecurityActions.getContextClassLoader();
            try {
                if (currentTCCL != null) {
                    SecurityActions.setContextClassLoader(null);
                }
                ctx = this.constructInitialLdapContext(this.bindDN, this.bindCredential);
                SearchControls constraints = new SearchControls();
                constraints.setSearchScope(this.searchScope);
                constraints.setReturningAttributes(new String[0]);
                constraints.setTimeLimit(this.searchTimeLimit);
                this.rolesSearch((InitialLdapContext)ctx, constraints, principal.getName(), this.recursion, 0, mappedObject);
            }
            catch (NamingException ne) {
                PicketBoxLogger.LOGGER.debugIgnoredException(ne);
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (NamingException ne) {
                        PicketBoxLogger.LOGGER.debugIgnoredException(ne);
                    }
                }
                if (currentTCCL != null) {
                    SecurityActions.setContextClassLoader(currentTCCL);
                }
            }
        }
    }

    protected InitialLdapContext constructInitialLdapContext(String dn, Object credential) throws NamingException {
        String authType;
        Properties env = new Properties();
        for (Map.Entry<String, Object> entry : this.options.entrySet()) {
            env.put(entry.getKey(), entry.getValue());
        }
        String factoryName = env.getProperty("java.naming.factory.initial");
        if (factoryName == null) {
            factoryName = "com.sun.jndi.ldap.LdapCtxFactory";
            env.setProperty("java.naming.factory.initial", factoryName);
        }
        if ((authType = env.getProperty("java.naming.security.authentication")) == null) {
            env.setProperty("java.naming.security.authentication", "simple");
        }
        String protocol = env.getProperty("java.naming.security.protocol");
        String providerURL = (String)this.options.get("java.naming.provider.url");
        if (providerURL == null) {
            providerURL = "ldap://localhost:" + (protocol != null && protocol.equals("ssl") ? "636" : "389");
        }
        env.setProperty("java.naming.provider.url", providerURL);
        if (dn != null) {
            env.setProperty("java.naming.security.principal", dn);
        }
        if (credential != null) {
            env.put("java.naming.security.credentials", credential);
        }
        this.traceLDAPEnv(env);
        return new InitialLdapContext(env, null);
    }

    protected void rolesSearch(InitialLdapContext ctx, SearchControls constraints, String user, int recursionMax, int nesting, RoleGroup roleGroup) throws NamingException {
        this.rolesSearch(ctx, constraints, user, null, recursionMax, nesting, roleGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rolesSearch(InitialLdapContext ctx, SearchControls constraints, String user, String previousRoleDn, int recursionMax, int nesting, RoleGroup roleGroup) throws NamingException {
        Object[] filterArgs = new Object[]{user};
        String searchFilter = previousRoleDn == null ? this.roleFilter : "member=" + previousRoleDn;
        try (NamingEnumeration<SearchResult> results = ctx.search(this.rolesCtxDN, searchFilter, filterArgs, constraints);){
            while (results.hasMore()) {
                String[] attrNames;
                SearchResult sr = results.next();
                String dn = this.canonicalize(sr.getName());
                Attributes result = ctx.getAttributes(dn, attrNames = new String[]{this.roleAttributeID});
                if (result != null && result.size() > 0) {
                    Attribute roles = result.get(this.roleAttributeID);
                    for (int n = 0; n < roles.size(); ++n) {
                        String roleName = (String)roles.get(n);
                        if (this.roleAttributeIsDN && this.parseRoleNameFromDN) {
                            this.parseRole(roleName, roleGroup);
                            continue;
                        }
                        if (this.roleAttributeIsDN) {
                            String roleDN = roleName;
                            String[] returnAttribute = new String[]{this.roleNameAttributeID};
                            PicketBoxLogger.LOGGER.traceFollowRoleDN(roleDN);
                            try {
                                Attributes result2 = ctx.getAttributes(roleDN, returnAttribute);
                                Attribute roles2 = result2.get(this.roleNameAttributeID);
                                if (roles2 == null) continue;
                                for (int m = 0; m < roles2.size(); ++m) {
                                    roleName = (String)roles2.get(m);
                                    this.addRole(roleName, roleGroup);
                                }
                                continue;
                            }
                            catch (NamingException e) {
                                PicketBoxLogger.LOGGER.debugFailureToQueryLDAPAttribute(this.roleNameAttributeID, roleDN, e);
                                continue;
                            }
                        }
                        this.addRole(roleName, roleGroup);
                    }
                }
                if (nesting >= recursionMax) continue;
                this.rolesSearch(ctx, constraints, user, dn, recursionMax, nesting + 1, roleGroup);
            }
        }
    }

    private String canonicalize(String searchResult) {
        String result = searchResult;
        int len = searchResult.length();
        String appendRolesCtxDN = "" + ("".equals(this.rolesCtxDN) ? "" : "," + this.rolesCtxDN);
        result = searchResult.endsWith("\"") ? searchResult.substring(0, len - 1) + appendRolesCtxDN + "\"" : searchResult + appendRolesCtxDN;
        return result;
    }

    private void addRole(String roleName, RoleGroup roleGroup) {
        if (roleName != null) {
            try {
                SimpleRole role = new SimpleRole(roleName);
                PicketBoxLogger.LOGGER.traceAssignUserToRole(roleName);
                roleGroup.addRole(role);
            }
            catch (Exception e) {
                PicketBoxLogger.LOGGER.debugFailureToCreatePrincipal(roleName, e);
            }
        }
    }

    private void parseRole(String dn, RoleGroup roleGroup) {
        StringTokenizer st = new StringTokenizer(dn, ",");
        while (st != null && st.hasMoreTokens()) {
            String keyVal = st.nextToken();
            if (keyVal.indexOf(this.roleNameAttributeID) <= -1) continue;
            StringTokenizer kst = new StringTokenizer(keyVal, "=");
            kst.nextToken();
            this.addRole(kst.nextToken(), roleGroup);
        }
    }

    private void traceLDAPEnv(Properties env) {
        Properties tmp = new Properties();
        tmp.putAll((Map<?, ?>)env);
        if (tmp.containsKey("java.naming.security.credentials")) {
            tmp.setProperty("java.naming.security.credentials", "******");
        }
        if (tmp.containsKey(BIND_CREDENTIAL)) {
            tmp.setProperty(BIND_CREDENTIAL, "******");
        }
        PicketBoxLogger.LOGGER.traceLDAPConnectionEnv(tmp);
    }
}

