/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.management.profile;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.component.TaskSkipPolicy;
import org.jboss.migration.wfly10.config.management.ProfileResource;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationCompositeSubtasks;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationCompositeTask;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceCompositeSubtasks;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceLeafTask;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceTaskRunnableBuilder;
import org.jboss.migration.wfly10.config.task.management.subsystem.AddSubsystemResources;

public class AddProfileTaskBuilder<S>
extends ManageableServerConfigurationCompositeTask.BaseBuilder<S, AddProfileTaskBuilder<S>> {
    protected final ManageableServerConfigurationCompositeSubtasks.Builder<S> subtasks;
    protected final String profileName;

    public AddProfileTaskBuilder(String profileName) {
        this.profileName = profileName;
        this.name("profile." + profileName + ".add");
        this.skipPolicyBuilders(new TaskSkipPolicy.Builder[]{TaskSkipPolicy.Builders.skipIfDefaultTaskSkipPropertyIsSet(), buildParameters -> context -> {
            if (!buildParameters.getServerConfiguration().findResources(ProfileResource.class, profileName).isEmpty()) {
                context.getLogger().debugf("Profile %s already exists.", (Object)profileName);
                return true;
            }
            return false;
        }});
        this.beforeRun(context -> context.getLogger().debugf("Adding profile %s...", (Object)profileName));
        this.subtasks = (ManageableServerConfigurationCompositeSubtasks.Builder)new ManageableServerConfigurationCompositeSubtasks.Builder().subtask(ProfileResource.Parent.class, new CreateProfileTask(profileName));
        this.subtasks(this.subtasks);
        this.afterRun(context -> context.getLogger().infof("Profile %s added.", (Object)profileName));
    }

    protected void addSubsystemSubtasks(AddSubsystemResources<S> ... addSubsystemSubtasks) {
        ManageableResourceCompositeSubtasks.Builder compositeSubtasks = new ManageableResourceCompositeSubtasks.Builder();
        for (AddSubsystemResources<S> subtask : addSubsystemSubtasks) {
            subtask.afterRun(null);
            compositeSubtasks.subtask(subtask);
        }
        this.subtasks.subtask(ProfileResource.class, this.profileName, compositeSubtasks);
    }

    protected AddProfileTaskBuilder<S> getThis() {
        return this;
    }

    public static class CreateProfileTask<S>
    extends ManageableResourceLeafTask.Builder<S, ProfileResource.Parent> {
        protected CreateProfileTask(String profileName) {
            this.name(new ServerMigrationTaskName.Builder("create-profile").addAttribute("name", profileName).build());
            ManageableResourceTaskRunnableBuilder runnableBuilder = params -> context -> {
                ProfileResource.Parent resource = (ProfileResource.Parent)params.getResource();
                PathAddress pathAddress = resource.getProfileResourcePathAddress(profileName);
                ModelNode op = Util.createAddOperation((PathAddress)pathAddress);
                resource.getServerConfiguration().executeManagementOperation(op);
                context.getLogger().debugf("Profile %s created.", (Object)profileName);
                return ServerMigrationTaskResult.SUCCESS;
            };
            this.runBuilder(runnableBuilder);
        }
    }
}

