/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3._private;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketAddress;
import javax.security.sasl.SaslException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.remoting3.ChannelBusyException;
import org.jboss.remoting3.NotOpenException;
import org.wildfly.security.auth.AuthenticationException;

@MessageLogger(projectCode="JBREM")
public interface Messages
extends BasicLogger {
    public static final Messages log = (Messages)Logger.getMessageLogger(Messages.class, (String)"org.jboss.remoting.remote");
    public static final Messages conn = (Messages)Logger.getMessageLogger(Messages.class, (String)"org.jboss.remoting.remote.connection");
    public static final Messages server = (Messages)Logger.getMessageLogger(Messages.class, (String)"org.jboss.remoting.remote.server");
    public static final Messages client = (Messages)Logger.getMessageLogger(Messages.class, (String)"org.jboss.remoting.remote.client");

    @Message(id=200, value="Remote connection failed: %s")
    @LogMessage(level=Logger.Level.DEBUG)
    public void connectionError(IOException var1);

    @Message(id=201, value="Received invalid message on %s")
    public IOException invalidMessage(Object var1);

    @Message(id=202, value="Abrupt close on %s")
    public IOException abruptClose(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=203, value="Message missing protocol byte")
    public void bufferUnderflowRaw();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=204, value="Buffer underflow parsing message with protocol ID %02x")
    public void bufferUnderflow(int var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=205, value="Failed to accept a connection: %s")
    public void failedToAccept(Exception var1);

    @Message(id=206, value="Channel is not open")
    public NotOpenException channelNotOpen();

    @Message(id=207, value="Failed to send a message (channel is busy)")
    public ChannelBusyException channelBusy();

    @Message(id=208, value="Write operation interrupted")
    public InterruptedIOException writeInterrupted();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=209, value="An exception occurred in a message handler")
    public void exceptionInUserHandler(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.FATAL)
    @Message(id=210, value="Internal Error: received a message with duplicate ID %d from %s")
    public void duplicateMessageId(short var1, SocketAddress var2);

    @Message(value="Internal Error: received a message with a duplicate ID")
    public IOException duplicateMessageIdException();

    @Message(id=211, value="Invalid XNIO worker; the worker must match the Remoting Endpoint worker")
    public IllegalArgumentException invalidWorker();

    @Message(id=212, value="Failed to configure SSL context")
    public IOException failedToConfigureSslContext(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Message with unknown protocol ID %d received")
    public void unknownProtocolId(int var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Rejected invalid SASL mechanism %s")
    public void rejectedInvalidMechanism(String var1);

    @Message(id=300, value="Authentication failed due to I/O error")
    public AuthenticationException authenticationExceptionIo(@Cause IOException var1);

    @Message(id=301, value="Mechanism name \"%s\" is too long")
    public IOException mechanismNameTooLong(String var1);

    @Message(id=302, value="Authentication message too large")
    public IOException authenticationMessageTooLarge();

    @Message(id=303, value="Authentication protocol failed (extra response)")
    public AuthenticationException authenticationExtraResponse();

    @Message(id=304, value="Server rejected authentication")
    public AuthenticationException serverRejectedAuthentication();

    @Message(id=305, value="Authentication failed (connection closed)")
    public AuthenticationException authenticationExceptionClosed();

    @Message(id=306, value="Authentication failed (SASL client construction failure)")
    public AuthenticationException authenticationNoSaslClient(@Cause SaslException var1);

    @Message(id=307, value="Authentication interrupted")
    public AuthenticationException authenticationInterrupted();

    @Message(id=308, value="Authentication failed (no mechanisms left), tried: %s")
    public AuthenticationException noAuthMechanismsLeft(String var1);

    @Message(id=309, value="Authentication not supported for this peer")
    public AuthenticationException authenticationNotSupported();
}

