/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n.verifier.processor;

import ch.qos.cal10n.BaseName;
import ch.qos.cal10n.verifier.Cal10nError;
import ch.qos.cal10n.verifier.processor.MessageKeyVerifierByTypeElement;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"ch.qos.cal10n.BaseName"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_5)
public class CAL10NAnnotationProcessor
extends AbstractProcessor {
    TypeElement baseNameTypeElement;
    Filer filer;

    @Override
    public void init(ProcessingEnvironment env) {
        super.init(env);
        this.note("CAL10NAnnotationProcessor 0.8.1 initialized");
        this.baseNameTypeElement = this.getType("ch.qos.cal10n.BaseName");
        this.filer = env.getFiler();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> entityAnnotated = roundEnv.getElementsAnnotatedWith(this.baseNameTypeElement);
        for (TypeElement typeElement : ElementFilter.typesIn(entityAnnotated)) {
            this.verify(typeElement);
        }
        return false;
    }

    private void verify(TypeElement typeElementForEnum) {
        MessageKeyVerifierByTypeElement modelMessageKeyVerifier = new MessageKeyVerifierByTypeElement(typeElementForEnum, this.filer);
        BaseName baseNameAnnotation = typeElementForEnum.getAnnotation(BaseName.class);
        List<Cal10nError> errorList = modelMessageKeyVerifier.verifyAllLocales();
        for (Cal10nError error : errorList) {
            this.error(error.toString(), typeElementForEnum);
        }
    }

    private TypeElement getType(String className) {
        return this.processingEnv.getElementUtils().getTypeElement(className);
    }

    void note(String s) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, s);
    }

    void warn(String s) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, s);
    }

    void error(String s, Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, s, element);
    }
}

