/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.locators.policy;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import org.jboss.security.xacml.bridge.PolicySetFinderModule;
import org.jboss.security.xacml.bridge.WrapperPolicyFinderModule;
import org.jboss.security.xacml.factories.PolicyFactory;
import org.jboss.security.xacml.interfaces.XACMLPolicy;
import org.jboss.security.xacml.jaxb.Option;
import org.jboss.security.xacml.locators.AbstractJBossPolicyLocator;
import org.jboss.security.xacml.sunxacml.AbstractPolicy;
import org.jboss.security.xacml.sunxacml.Policy;
import org.jboss.security.xacml.sunxacml.PolicySet;
import org.jboss.security.xacml.util.LDAPCommon;

public class JBossLDAPPolicyLocator
extends AbstractJBossPolicyLocator {
    protected static Logger log = Logger.getLogger(JBossLDAPPolicyLocator.class.getName());
    protected LDAPCommon ldapCommon = new LDAPCommon();

    @Override
    public void setPolicies(Set<XACMLPolicy> policies) {
    }

    @Override
    public void setOptions(List<Option> theoptions) {
        super.setOptions(theoptions);
        this.ldapCommon.processOptions(theoptions);
        this.init();
    }

    protected void init() {
        this.ldapCommon.validateConfiguration(LDAPCommon.TYPE.POLICY);
        this.search();
    }

    protected void search() {
        NamingEnumeration<SearchResult> results = null;
        try {
            this.ldapCommon.constructJNDIContext();
            results = this.ldapCommon.search(null);
            while (results.hasMore()) {
                Attribute xml;
                SearchResult rs = results.next();
                Attributes attributes = rs.getAttributes();
                if (attributes == null || (xml = attributes.get(this.ldapCommon.getLdapAttribute())) == null) continue;
                String xmlString = (String)xml.get();
                try {
                    byte[] xmlStream = xmlString.getBytes("UTF-8");
                    XACMLPolicy policy = PolicyFactory.createPolicy(new ByteArrayInputStream(xmlStream));
                    if (policy == null) continue;
                    if (policy.getType() == 1) {
                        Policy p = (Policy)policy.get("underlying_policy");
                        WrapperPolicyFinderModule wpfm = new WrapperPolicyFinderModule(p);
                        this.pfml.add(wpfm);
                    }
                    if (policy.getType() != 0) continue;
                    this.pfml.add(this.getPopulatedPolicySetFinderModule(policy));
                }
                catch (UnsupportedEncodingException e) {
                    log.severe(e.getMessage());
                }
                catch (Exception e) {
                    log.severe(e.getMessage());
                }
            }
            this.map.put("policy_finder_module", this.pfml);
        }
        catch (NamingException e) {
            log.severe(e.getMessage());
            throw new IllegalStateException(e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (NamingException namingException) {}
            }
            try {
                this.ldapCommon.closeJNDIContext();
            }
            catch (NamingException namingException) {}
        }
    }

    private PolicySetFinderModule getPopulatedPolicySetFinderModule(XACMLPolicy xpolicy) {
        PolicySetFinderModule psfm = new PolicySetFinderModule();
        ArrayList<AbstractPolicy> sunxacmlPolicies = new ArrayList<AbstractPolicy>();
        this.recursivePopulate(xpolicy, sunxacmlPolicies, psfm);
        psfm.set((PolicySet)xpolicy.get("underlying_policy"), sunxacmlPolicies);
        xpolicy.set("policy_finder_module", psfm);
        return psfm;
    }

    private void recursivePopulate(XACMLPolicy policy, List<AbstractPolicy> policies, PolicySetFinderModule psfm) {
        List<XACMLPolicy> policyList = policy.getEnclosingPolicies();
        for (XACMLPolicy xp : policyList) {
            AbstractPolicy p = (AbstractPolicy)xp.get("underlying_policy");
            policies.add(p);
            if (!(p instanceof PolicySet)) continue;
            this.recursivePopulate(xp, policies, psfm);
        }
    }
}

