/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.LinkedList;
import java.util.List;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.core.api.management.ConnectionManager;
import org.jboss.jca.core.api.management.Connector;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.msc.service.ServiceController;

public class EnlistmentTraceAttributeWriteHandler
extends AbstractWriteAttributeHandler<List<ConnectionManager>> {
    protected EnlistmentTraceAttributeWriteHandler() {
        super(new AttributeDefinition[]{Constants.ENLISTMENT_TRACE});
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String parameterName, ModelNode newValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<List<ConnectionManager>> handbackHolder) throws OperationFailedException {
        String jndiName = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().get(Constants.JNDINAME.getName()).asString();
        ServiceController managementRepoService = context.getServiceRegistry(false).getService(ConnectorServices.MANAGEMENT_REPOSITORY_SERVICE);
        Boolean boolValue = Constants.ENLISTMENT_TRACE.resolveValue(context, newValue).asBoolean();
        try {
            ManagementRepository repository = (ManagementRepository)managementRepoService.getValue();
            if (repository.getConnectors() != null) {
                LinkedList<ConnectionManager> handback = new LinkedList<ConnectionManager>();
                for (Connector connector : repository.getConnectors()) {
                    for (ConnectionManager cm : connector.getConnectionManagers()) {
                        if (!jndiName.equalsIgnoreCase(cm.getUniqueId())) continue;
                        cm.setEnlistmentTrace(boolValue);
                        handback.add(cm);
                    }
                }
                handbackHolder.setHandback(handback);
            }
        }
        catch (Exception e) {
            throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.failedToSetAttribute(e.getLocalizedMessage()));
        }
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String parameterName, ModelNode valueToRestore, ModelNode valueToRevert, List<ConnectionManager> handback) throws OperationFailedException {
        Boolean value = Constants.ENLISTMENT_TRACE.resolveValue(context, valueToRestore).asBoolean();
        if (handback != null) {
            for (ConnectionManager ds : handback) {
                ds.setEnlistmentTrace(value);
            }
        }
    }
}

