/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.service;

import java.util.Map;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.as.webservices.publish.EndpointPublisherHelper;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;

public final class EndpointDeployService
implements Service {
    private final ServiceName name;
    private final DeploymentUnit unit;

    private EndpointDeployService(String context, DeploymentUnit unit) {
        this.name = WSServices.ENDPOINT_DEPLOY_SERVICE.append(new String[]{context});
        this.unit = unit;
    }

    public ServiceName getName() {
        return this.name;
    }

    public void start(StartContext ctx) throws StartException {
        WSLogger.ROOT_LOGGER.starting(this.name);
        try {
            EndpointPublisherHelper.doDeployStep(ctx.getChildTarget(), this.unit);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext ctx) {
        WSLogger.ROOT_LOGGER.stopping(this.name);
        try {
            EndpointPublisherHelper.undoDeployStep(this.unit);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static DeploymentUnit install(ServiceTarget serviceTarget, String context, ClassLoader loader, String hostName, Map<String, String> urlPatternToClassName, JBossWebMetaData jbwmd, WebservicesMetaData wsmd, JBossWebservicesMetaData jbwsmd) {
        return EndpointDeployService.install(serviceTarget, context, loader, hostName, urlPatternToClassName, jbwmd, wsmd, jbwsmd, null);
    }

    public static DeploymentUnit install(ServiceTarget serviceTarget, String context, ClassLoader loader, String hostName, Map<String, String> urlPatternToClassName, JBossWebMetaData jbwmd, WebservicesMetaData wsmd, JBossWebservicesMetaData jbwsmd, Map<Class<?>, Object> deploymentAttachments) {
        DeploymentUnit unit = EndpointPublisherHelper.doPrepareStep(context, loader, urlPatternToClassName, jbwmd, wsmd, jbwsmd);
        if (deploymentAttachments != null) {
            Deployment dep = (Deployment)unit.getAttachment(WSAttachmentKeys.DEPLOYMENT_KEY);
            for (Map.Entry<Class<?>, Object> e : deploymentAttachments.entrySet()) {
                dep.addAttachment(e.getKey(), e.getValue());
            }
        }
        EndpointDeployService service = new EndpointDeployService(context, unit);
        ServiceBuilder builder = serviceTarget.addService(service.getName());
        builder.requires(WSServices.CONFIG_SERVICE);
        builder.setInstance((Service)service);
        builder.install();
        return unit;
    }
}

