/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.driver;

import java.sql.Driver;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.services.driver.InstalledDriver;
import org.jboss.as.connector.services.driver.registry.DriverRegistry;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class DriverService
implements Service<Driver> {
    private final InjectedValue<DriverRegistry> injectedDriverRegistry = new InjectedValue();
    private final InstalledDriver driverMetaData;
    private final Driver driver;

    public DriverService(InstalledDriver driverMetaData, Driver driver) {
        assert (driverMetaData != null) : ConnectorLogger.ROOT_LOGGER.nullVar("driverMetaData");
        assert (driver != null) : ConnectorLogger.ROOT_LOGGER.nullVar("driver");
        this.driverMetaData = driverMetaData;
        this.driver = driver;
    }

    public Driver getValue() throws IllegalStateException, IllegalArgumentException {
        return this.driver;
    }

    public void start(StartContext context) throws StartException {
        ((DriverRegistry)this.injectedDriverRegistry.getValue()).registerInstalledDriver(this.driverMetaData);
        ConnectorLogger.DEPLOYER_JDBC_LOGGER.startedDriverService(this.driverMetaData.getDriverName());
    }

    public void stop(StopContext context) {
        ((DriverRegistry)this.injectedDriverRegistry.getValue()).unregisterInstalledDriver(this.driverMetaData);
        ConnectorLogger.DEPLOYER_JDBC_LOGGER.stoppedDriverService(this.driverMetaData.getDriverName());
    }

    public Injector<DriverRegistry> getDriverRegistryServiceInjector() {
        return this.injectedDriverRegistry;
    }
}

