/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.jboss;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.migration.core.jboss.ModuleIdentifier;

public class ModuleSpecification {
    private final ModuleIdentifier moduleIdentifier;
    private final List<Dependency> dependencies;

    protected ModuleSpecification(Builder builder) {
        this.moduleIdentifier = builder.moduleIdentifier;
        this.dependencies = Collections.unmodifiableList(builder.dependencies);
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public ModuleIdentifier getModuleIdentifier() {
        return this.moduleIdentifier;
    }

    public static class Builder {
        private final ModuleIdentifier moduleIdentifier;
        private final List<Dependency> dependencies;

        public Builder(ModuleIdentifier moduleIdentifier) {
            this.moduleIdentifier = moduleIdentifier;
            this.dependencies = new ArrayList<Dependency>();
        }

        public Builder dependency(Dependency dependency) {
            this.dependencies.add(dependency);
            return this;
        }

        public ModuleSpecification build() {
            return new ModuleSpecification(this);
        }
    }

    public static class Dependency {
        private final ModuleIdentifier moduleId;
        private final boolean optional;

        public Dependency(ModuleIdentifier moduleId, boolean optional) {
            this.moduleId = moduleId;
            this.optional = optional;
        }

        public ModuleIdentifier getId() {
            return this.moduleId;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public String toString() {
            return "[" + this.moduleId + (this.optional ? ",optional=true" : "") + "]";
        }
    }

    public static class Parser {
        public static ModuleSpecification parse(Path inputFile) throws IOException, XMLStreamException {
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputFile.toFile()));){
                ModuleSpecification moduleSpecification = Parser.parse(in);
                return moduleSpecification;
            }
        }

        public static ModuleSpecification parse(InputStream in) throws IOException, XMLStreamException {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(in);
            reader.require(7, null, null);
            while (reader.hasNext()) {
                int type = reader.next();
                switch (type) {
                    case 1: {
                        if (reader.getLocalName().equals("module")) {
                            return Parser.parseModule(reader);
                        }
                        if (!reader.getLocalName().equals("module-alias")) break;
                        return Parser.parseModuleAlias(reader);
                    }
                }
            }
            throw new XMLStreamException("expected XML elements not found");
        }

        private static ModuleSpecification parseModule(XMLStreamReader reader) throws XMLStreamException {
            int count = reader.getAttributeCount();
            String name = null;
            String slot = "main";
            for (int i = 0; i < count; ++i) {
                if ("name".equals(reader.getAttributeName(i).getLocalPart())) {
                    name = reader.getAttributeValue(i);
                    continue;
                }
                if (!"slot".equals(reader.getAttributeName(i).getLocalPart())) continue;
                slot = reader.getAttributeValue(i);
            }
            Builder builder = new Builder(ModuleIdentifier.create(name, slot));
            while (reader.hasNext()) {
                int type = reader.next();
                switch (type) {
                    case 1: {
                        if (reader.getLocalName().equals("dependencies")) {
                            Parser.parseDependencies(reader, builder);
                        }
                    }
                    case 2: {
                        if (!reader.getLocalName().equals("module")) break;
                        return builder.build();
                    }
                }
            }
            throw new IllegalStateException("Unexpected end of module.xml");
        }

        private static ModuleSpecification parseModuleAlias(XMLStreamReader reader) throws XMLStreamException {
            String targetName = "";
            String targetSlot = "main";
            String name = null;
            String slot = "main";
            boolean optional = false;
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String localName = reader.getAttributeLocalName(i);
                if (localName.equals("target-name")) {
                    targetName = reader.getAttributeValue(i);
                    continue;
                }
                if (localName.equals("target-slot")) {
                    targetSlot = reader.getAttributeValue(i);
                    continue;
                }
                if (localName.equals("name")) {
                    name = reader.getAttributeValue(i);
                    continue;
                }
                if (!localName.equals("slot")) continue;
                slot = reader.getAttributeValue(i);
            }
            return new Builder(ModuleIdentifier.create(name, slot)).dependency(new Dependency(ModuleIdentifier.create(targetName, targetSlot), optional)).build();
        }

        private static void parseDependencies(XMLStreamReader reader, Builder builder) throws XMLStreamException {
            while (reader.hasNext()) {
                int type = reader.next();
                switch (type) {
                    case 1: {
                        if (!reader.getLocalName().equals("module")) break;
                        String name = "";
                        String slot = "main";
                        boolean optional = false;
                        for (int i = 0; i < reader.getAttributeCount(); ++i) {
                            String localName = reader.getAttributeLocalName(i);
                            if (localName.equals("name")) {
                                name = reader.getAttributeValue(i);
                                continue;
                            }
                            if (localName.equals("slot")) {
                                slot = reader.getAttributeValue(i);
                                continue;
                            }
                            if (!localName.equals("optional")) continue;
                            optional = Boolean.parseBoolean(reader.getAttributeValue(i));
                        }
                        ModuleIdentifier dependencyId = ModuleIdentifier.create(name, slot);
                        builder.dependency(new Dependency(dependencyId, optional));
                        break;
                    }
                    case 2: {
                        if (!reader.getLocalName().equals("dependencies")) break;
                        return;
                    }
                }
            }
        }
    }
}

