/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import org.apache.james.mime4j.field.AbstractField;
import org.apache.james.mime4j.field.FieldParser;
import org.apache.james.mime4j.field.ParsedField;
import org.apache.james.mime4j.util.ByteSequence;

public class ContentTransferEncodingField
extends AbstractField {
    private String encoding;
    static final FieldParser PARSER = new FieldParser(){

        @Override
        public ParsedField parse(String name, String body, ByteSequence raw) {
            return new ContentTransferEncodingField(name, body, raw);
        }
    };

    ContentTransferEncodingField(String name, String body, ByteSequence raw) {
        super(name, body, raw);
        this.encoding = body.trim().toLowerCase();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public static String getEncoding(ContentTransferEncodingField f) {
        if (f != null && f.getEncoding().length() != 0) {
            return f.getEncoding();
        }
        return "7bit";
    }
}

