/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.wildfly.clustering.marshalling.protostream.EnumMarshaller;
import org.wildfly.security.manager.WildFlySecurityManager;

public class MarshallerProvider
implements SerializationContext.MarshallerProvider {
    private final Predicate<Class<?>> superClassPredicate;
    private final Map<String, BaseMarshaller<?>> marshallerByName = new HashMap();
    private final Map<Class<?>, BaseMarshaller<?>> marshallerByType = new IdentityHashMap();

    public MarshallerProvider(Predicate<Class<?>> superClassPredicate, BaseMarshaller<?> ... marshallers) {
        this(superClassPredicate, Arrays.asList(marshallers));
    }

    public MarshallerProvider(Predicate<Class<?>> superClassPredicate, Iterable<? extends BaseMarshaller<?>> marshallers) {
        this(superClassPredicate, marshallers.iterator());
    }

    public MarshallerProvider(Predicate<Class<?>> superClassPredicate, Stream<? extends BaseMarshaller<?>> marshallers) {
        this(superClassPredicate, marshallers.iterator());
    }

    private MarshallerProvider(Predicate<Class<?>> superClassPredicate, Iterator<? extends BaseMarshaller<?>> marshallers) {
        this.superClassPredicate = superClassPredicate;
        while (marshallers.hasNext()) {
            Object marshaller = marshallers.next();
            if (marshaller.getJavaClass().isEnum() && !(marshaller instanceof org.infinispan.protostream.EnumMarshaller)) {
                marshaller = new EnumMarshaller<Enum>(marshaller.getJavaClass().asSubclass(Enum.class));
            }
            this.marshallerByName.put(marshaller.getTypeName(), (BaseMarshaller<?>)marshaller);
            this.marshallerByType.put(marshaller.getJavaClass(), (BaseMarshaller<?>)marshaller);
        }
    }

    public BaseMarshaller<?> getMarshaller(String typeName) {
        return this.marshallerByName.get(typeName);
    }

    public BaseMarshaller<?> getMarshaller(Class<?> javaClass) {
        Class<?> targetClass = javaClass;
        Class<?> superClass = javaClass.getSuperclass();
        ClassLoader loader = WildFlySecurityManager.getClassLoaderPrivileged(targetClass);
        while (!this.marshallerByType.containsKey(targetClass) && superClass != null && this.superClassPredicate.test(superClass) && WildFlySecurityManager.getClassLoaderPrivileged(superClass) == loader) {
            targetClass = superClass;
            superClass = targetClass.getSuperclass();
        }
        return this.marshallerByType.get(targetClass);
    }

    public static enum ClassPredicate implements Predicate<Class<?>>
    {
        ABSTRACT{

            @Override
            public boolean test(Class<?> superClass) {
                return Modifier.isAbstract(superClass.getModifiers());
            }
        };

    }
}

