/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.push;

import com.sun.faces.cdi.CdiUtils;
import com.sun.faces.push.WebsocketUserManager;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.util.AnnotationLiteral;
import javax.faces.context.FacesContext;
import javax.faces.event.WebsocketEvent;
import javax.inject.Inject;
import javax.websocket.CloseReason;
import javax.websocket.Session;

@ApplicationScoped
public class WebsocketSessionManager {
    private static final Logger logger = Logger.getLogger(WebsocketSessionManager.class.getName());
    private static final CloseReason REASON_EXPIRED = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "Expired");
    private static final AnnotationLiteral<WebsocketEvent.Opened> SESSION_OPENED = new AnnotationLiteral<WebsocketEvent.Opened>(){
        private static final long serialVersionUID = 1L;
    };
    private static final AnnotationLiteral<WebsocketEvent.Closed> SESSION_CLOSED = new AnnotationLiteral<WebsocketEvent.Closed>(){
        private static final long serialVersionUID = 1L;
    };
    private static final long TOMCAT_WEB_SOCKET_RETRY_TIMEOUT = 10L;
    private static final long TOMCAT_WEB_SOCKET_MAX_RETRIES = 100L;
    private static final String WARNING_TOMCAT_WEB_SOCKET_BOMBED = "Tomcat cannot handle concurrent push messages. A push message has been sent only after %s retries of 10ms apart. Consider rate limiting sending push messages. For example, once every 500ms.";
    private static final String ERROR_TOMCAT_WEB_SOCKET_BOMBED = "Tomcat cannot handle concurrent push messages. A push message could NOT be sent after %s retries of 10ms apart. Consider rate limiting sending push messages. For example, once every 500ms.";
    private final ConcurrentMap<String, Collection<Session>> socketSessions = new ConcurrentHashMap<String, Collection<Session>>();
    @Inject
    private WebsocketUserManager socketUsers;
    private static volatile WebsocketSessionManager instance;

    protected void register(String channelId) {
        if (!this.socketSessions.containsKey(channelId)) {
            this.socketSessions.putIfAbsent(channelId, new ConcurrentLinkedQueue());
        }
    }

    protected void register(Iterable<String> channelIds) {
        for (String channelId : channelIds) {
            this.register(channelId);
        }
    }

    protected boolean add(Session session) {
        String channelId = WebsocketSessionManager.getChannelId(session);
        Collection sessions = (Collection)this.socketSessions.get(channelId);
        if (sessions != null && sessions.add(session)) {
            Serializable user = this.socketUsers.getUser(WebsocketSessionManager.getChannel(session), channelId);
            if (user != null) {
                session.getUserProperties().put("user", user);
            }
            WebsocketSessionManager.fireEvent(session, null, SESSION_OPENED);
            return true;
        }
        return false;
    }

    protected Set<Future<Void>> send(String channelId, String message) {
        Collection sessions;
        Collection collection = sessions = channelId != null ? (Collection)this.socketSessions.get(channelId) : null;
        if (sessions != null && !sessions.isEmpty()) {
            HashSet<Future<Void>> results = new HashSet<Future<Void>>(sessions.size());
            for (Session session : sessions) {
                if (!session.isOpen()) continue;
                results.add(this.send(session, message, true));
            }
            return results;
        }
        return Collections.emptySet();
    }

    private Future<Void> send(Session session, String text, boolean retrySendTomcatWebSocket) {
        try {
            return session.getAsyncRemote().sendText(text);
        }
        catch (IllegalStateException e) {
            if (session.getClass().getName().startsWith("org.apache.tomcat.websocket.") && e.getMessage().contains("[TEXT_FULL_WRITING]")) {
                if (retrySendTomcatWebSocket) {
                    return CompletableFuture.supplyAsync(() -> this.retrySendTomcatWebSocket(session, text));
                }
                return null;
            }
            throw e;
        }
    }

    private Void retrySendTomcatWebSocket(Session session, String text) {
        int retries = 0;
        Exception cause = null;
        while ((long)(++retries) < 100L) {
            try {
                Thread.sleep(10L);
                if (session.isOpen()) {
                    Future<Void> result = this.send(session, text, false);
                    if (result == null) continue;
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, String.format(WARNING_TOMCAT_WEB_SOCKET_BOMBED, retries));
                    }
                    return result.get();
                }
                cause = new IllegalStateException("Too bad, session is now closed");
                break;
            }
            catch (InterruptedException | ExecutionException e) {
                Thread.currentThread().interrupt();
                cause = e;
                break;
            }
        }
        throw new UnsupportedOperationException(String.format(ERROR_TOMCAT_WEB_SOCKET_BOMBED, retries), cause);
    }

    protected void remove(Session session, CloseReason reason) {
        Collection sessions = (Collection)this.socketSessions.get(WebsocketSessionManager.getChannelId(session));
        if (sessions != null && sessions.remove(session)) {
            WebsocketSessionManager.fireEvent(session, reason, SESSION_CLOSED);
        }
    }

    protected void deregister(Iterable<String> channelIds) {
        for (String channelId : channelIds) {
            Collection sessions = (Collection)this.socketSessions.remove(channelId);
            if (sessions == null) continue;
            for (Session session : sessions) {
                if (!session.isOpen()) continue;
                try {
                    session.close(REASON_EXPIRED);
                }
                catch (IOException ignore) {}
            }
        }
    }

    static WebsocketSessionManager getInstance() {
        if (instance == null) {
            instance = CdiUtils.getBeanReference(WebsocketSessionManager.class, new Annotation[0]);
        }
        return instance;
    }

    private static String getChannel(Session session) {
        return (String)session.getPathParameters().get("channel");
    }

    private static String getChannelId(Session session) {
        return session.getQueryString();
    }

    private static void fireEvent(Session session, CloseReason reason, AnnotationLiteral<?> qualifier) {
        Serializable user = (Serializable)session.getUserProperties().get("user");
        Util.getCdiBeanManager(FacesContext.getCurrentInstance()).fireEvent((Object)new WebsocketEvent(WebsocketSessionManager.getChannel(session), user, reason != null ? reason.getCloseCode() : null), new Annotation[]{qualifier});
    }
}

