/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.security.X509ExtendedDeployTrustManagerDelegate;
import com.sun.deploy.trace.Trace;
import com.sun.net.ssl.internal.ssl.X509ExtendedTrustManager;
import java.lang.reflect.Method;
import java.net.Socket;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;

public final class X509ExtendedDeployTrustManager
extends X509ExtendedTrustManager {
    private final X509ExtendedDeployTrustManagerDelegate delegate = new X509ExtendedDeployTrustManagerDelegate();

    public synchronized void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.checkClientTrusted(x509CertificateArray, string, null, null);
    }

    public synchronized void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, String string2, String string3) throws CertificateException {
        this.delegate.checkClientTrusted(x509CertificateArray, string, string2, string3);
    }

    public synchronized void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.checkServerTrusted(x509CertificateArray, string, null, null);
    }

    public synchronized void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, String string2, String string3) throws CertificateException {
        this.delegate.checkServerTrusted(x509CertificateArray, string, string2, string3);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.delegate.getAcceptedIssuers();
    }

    public synchronized void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        throw new UnsupportedOperationException("The operation is not supported in deploy TM");
    }

    public synchronized void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        SSLSession sSLSession = this.getSessionFromSocket(socket);
        String string2 = this.getAlgorithmFromSocket(socket);
        String string3 = sSLSession.getPeerHost();
        int n = sSLSession.getPeerPort();
        this.delegate.checkClientTrusted(x509CertificateArray, string, string3, n, string2, socket);
    }

    public synchronized void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        throw new UnsupportedOperationException("The operation is not supported in deploy TM");
    }

    public synchronized void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        SSLSession sSLSession = this.getSessionFromSocket(socket);
        String string2 = this.getAlgorithmFromSocket(socket);
        String string3 = sSLSession.getPeerHost();
        int n = sSLSession.getPeerPort();
        this.delegate.checkServerTrusted(x509CertificateArray, string, string3, n, string2, socket);
    }

    String getAlgorithmFromSocket(Socket socket) {
        String string;
        block5: {
            string = null;
            try {
                if (Config.isJavaVersionAtLeast16() && !Config.isDeployVersionAtLeast11()) {
                    String string2 = "com.sun.net.ssl.internal.ssl.SSLSocketImpl";
                    Class<?> clazz = Class.forName(string2);
                    boolean bl = clazz.isInstance(socket);
                    if (bl) {
                        Object obj = clazz.cast(socket);
                        Method method = clazz.getDeclaredMethod("getSSLParameters", null);
                        String string3 = "com.sun.net.ssl.internal.ssl.ExtendedSSLParameters";
                        Class<?> clazz2 = Class.forName(string3);
                        boolean bl2 = clazz2.isInstance(method.invoke(obj, null));
                        if (bl2) {
                            Object obj2 = clazz2.cast(method.invoke(obj, null));
                            Method method2 = clazz2.getDeclaredMethod("getEndpointIdentificationAlgorithm", null);
                            string = (String)method2.invoke(obj2, null);
                        }
                    }
                    break block5;
                }
                throw new UnsupportedOperationException("The operation is not supported in deploy TM");
            }
            catch (Exception exception) {
                if (exception == null) break block5;
                Trace.msgSecurityPrintln(exception.toString());
            }
        }
        return string;
    }

    SSLSession getSessionFromSocket(Socket socket) {
        SSLSession sSLSession;
        block4: {
            sSLSession = null;
            try {
                if (Config.isJavaVersionAtLeast16() && !Config.isDeployVersionAtLeast11()) {
                    String string = "com.sun.net.ssl.internal.ssl.SSLSocketImpl";
                    Class<?> clazz = Class.forName(string);
                    boolean bl = clazz.isInstance(socket);
                    if (bl) {
                        Object obj = clazz.cast(socket);
                        Method method = clazz.getDeclaredMethod("getHandshakeSession", null);
                        sSLSession = (SSLSession)method.invoke(obj, null);
                    }
                    break block4;
                }
                throw new UnsupportedOperationException("The operation is not supported in deploy TM");
            }
            catch (Exception exception) {
                if (exception == null) break block4;
                Trace.msgSecurityPrintln(exception.toString());
            }
        }
        return sSLSession;
    }
}

