/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security.ruleset;

import com.sun.deploy.config.Config;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.URLUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSigner;
import java.security.cert.Certificate;
import java.util.List;

public class RuleId {
    protected String title;
    protected String location;
    protected String htmlLocation;
    protected String jnlpLocation;
    protected URL anchorURL;
    protected String jarLocation;
    protected String jarVersion;
    protected String certAlgorithm;
    protected String certHash;
    protected String checksumAlg;
    protected String checksumHash;
    protected boolean isArtifactId;
    protected boolean isDocbaseId;
    String[] exceptionSites = null;

    public RuleId(String string, String string2, String string3, URL uRL, String string4, String string5) {
        this.title = string;
        this.htmlLocation = string2;
        this.jnlpLocation = string3;
        this.location = string3 != null ? string3 : string2;
        this.anchorURL = uRL;
        this.jarLocation = string4;
        this.jarVersion = string5;
        this.certAlgorithm = null;
        this.certHash = null;
        this.checksumAlg = null;
        this.checksumHash = null;
        this.isArtifactId = true;
        this.isDocbaseId = false;
    }

    public RuleId(String string, String string2, String string3, String string4, String string5, String string6) {
        this.title = string;
        this.htmlLocation = null;
        this.jnlpLocation = null;
        this.location = string2;
        this.anchorURL = null;
        this.jarLocation = null;
        this.jarVersion = null;
        this.certAlgorithm = string3;
        this.certHash = string4;
        this.checksumAlg = string5;
        this.checksumHash = string6;
        this.isArtifactId = false;
        this.isDocbaseId = false;
    }

    public RuleId(String string) {
        this.title = null;
        this.htmlLocation = string;
        this.jnlpLocation = null;
        this.location = string;
        this.anchorURL = null;
        this.jarLocation = null;
        this.jarVersion = null;
        this.certAlgorithm = null;
        this.certHash = null;
        this.checksumAlg = null;
        this.checksumHash = null;
        this.isArtifactId = false;
        this.isDocbaseId = true;
    }

    public boolean contains(RuleId ruleId) {
        Certificate[] certificateArray;
        Resource resource;
        if (!this.isArtifactId && ruleId.isDocbaseId) {
            try {
                if (this.title == null && this.certHash == null && this.checksumHash == null && (this.location == null || RuleId.compareStringToURL(this.location, new URL(ruleId.location), true, true))) {
                    Trace.println("Matching Rule id for docbase only: " + this, TraceLevel.RULESET);
                    return true;
                }
            }
            catch (Exception exception) {
                Trace.ignored(exception);
            }
            Trace.println("Rule location: " + this.location + " doesn't match " + "docbase location: " + ruleId.location, TraceLevel.RULESET);
            return false;
        }
        if (this.isArtifactId || !ruleId.isArtifactId) {
            Trace.println("Id.contains() called with wrong id types ?");
            return false;
        }
        if (this.title != null && !this.title.equals(ruleId.title)) {
            Trace.println("Rule title: " + this.title + " doesn't match artifactId: " + ruleId.title, TraceLevel.RULESET);
            return false;
        }
        Trace.println("Rule title: " + this.title + " matches artifactId: " + ruleId.title, TraceLevel.RULESET);
        if (this.location != null) {
            try {
                if (ruleId.location == null) {
                    Trace.println("Rule location: " + this.location + " does not match UNKNOWN artifact location", TraceLevel.RULESET);
                    return false;
                }
                boolean bl = RuleId.compareStringToURL(this.location, new URL(ruleId.location), true, true);
                if (!bl) {
                    Trace.println("Rule location: " + this.location + " does not match artifact location: " + ruleId.location, TraceLevel.RULESET);
                    return false;
                }
            }
            catch (Exception exception) {
                Trace.ignored(exception);
                return false;
            }
        }
        Trace.println("Rule location: " + this.location + " matches artifactId: " + ruleId.location, TraceLevel.RULESET);
        if (this.certHash != null) {
            try {
                URL uRL = new URL(ruleId.jarLocation);
                resource = ResourceProvider.get().getResource(uRL, ruleId.jarVersion);
                certificateArray = null;
                boolean bl = false;
                String string = null;
                if (Config.isJavaVersionAtLeast15()) {
                    CodeSigner[] codeSignerArray = resource.getCodeSigners();
                    for (int i = 0; codeSignerArray != null && i < codeSignerArray.length; ++i) {
                        List<? extends Certificate> list = codeSignerArray[i].getSignerCertPath().getCertificates();
                        certificateArray = list.toArray(new Certificate[0]);
                        if (certificateArray == null || !this.certHash.equals(string = CertUtils.getMainCertHash(certificateArray, this.certAlgorithm))) continue;
                        bl = true;
                        break;
                    }
                } else {
                    certificateArray = resource.getCertificates();
                    if (certificateArray != null && this.certHash.equals(string = CertUtils.getMainCertHash(certificateArray, this.certAlgorithm))) {
                        bl = true;
                    }
                }
                if (certificateArray == null) {
                    Trace.println("Rule hash not matching certificate hash because cannot get certificates from resource: " + uRL, TraceLevel.RULESET);
                    return false;
                }
                if (!bl) {
                    Trace.println("Rule hash:\n         " + this.certHash + "\n" + "not matching artifact certificate hash:\n         " + string, TraceLevel.RULESET);
                    return false;
                }
                Trace.println("Rule hash matches certificate hash", TraceLevel.RULESET);
            }
            catch (IOException iOException) {
                Trace.println("IOException: " + iOException + "while finding hash for: " + ruleId.jarLocation, TraceLevel.RULESET);
                Trace.ignored(iOException);
                return false;
            }
        }
        if (this.checksumHash != null) {
            try {
                URL uRL = new URL(ruleId.jarLocation);
                resource = ResourceProvider.get().getResource(uRL, ruleId.jarVersion);
                certificateArray = SystemUtils.getFileChecksum(resource.getDataFile(), this.checksumAlg);
                if (!this.checksumHash.equals(certificateArray)) {
                    Trace.println("Rule checksum:  not equal artifact checksum:\n    " + (String)certificateArray, TraceLevel.RULESET);
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                Trace.println("invalid checksum in rule: " + this.checksumHash);
                return false;
            }
            catch (IOException iOException) {
                Trace.println("IOException: " + iOException + " while finding checksum for: " + ruleId.jarLocation, TraceLevel.RULESET);
                Trace.ignored(iOException);
                return false;
            }
        }
        Trace.println("Matching Rule ID: " + this, TraceLevel.RULESET);
        return true;
    }

    public String toString() {
        String string = "\n        title: " + this.title + "\n        location: " + this.location;
        if (this.jarLocation != null) {
            string = string + "\n        jar location: " + this.jarLocation + "\n        jar version: " + this.jarVersion;
        }
        if (this.certHash != null) {
            string = string + "\n        certificate algorithm: " + this.certAlgorithm + "\n        certificate hash: " + this.certHash;
        }
        if (this.checksumHash != null) {
            string = string + "\n        checksum algorithm: " + this.checksumAlg + "\n        checksum hash: " + this.checksumHash;
        }
        string = string + "\n        isArtifact: " + this.isArtifactId;
        return string;
    }

    public static boolean compareStringToURL(String string, URL uRL, boolean bl, boolean bl2) {
        int n;
        String string2 = uRL.getHost();
        String string3 = uRL.getProtocol();
        int n2 = uRL.getDefaultPort();
        int n3 = uRL.getPort();
        String string4 = uRL.getPath();
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        URL uRL2 = null;
        try {
            uRL2 = new URL(string);
            string6 = uRL2.getProtocol();
            string5 = uRL2.getHost();
            n = uRL2.getPort();
            string7 = uRL2.getPath();
        }
        catch (MalformedURLException malformedURLException) {
            try {
                uRL2 = new URL("http://" + string);
                string6 = null;
                string5 = uRL2.getHost();
                n = uRL2.getPort();
                string7 = uRL2.getPath();
            }
            catch (MalformedURLException malformedURLException2) {
                Trace.println("invalid location: " + string, TraceLevel.RULESET);
                return false;
            }
        }
        Trace.println("RuleId compare: (" + string6 + ", " + string5 + ", " + n + ", " + string7 + ") to url: " + uRL, TraceLevel.RULESET);
        if (bl) {
            if (n == -1 || n == n3 || n == n2 && n3 == -1) {
                bl5 = true;
            }
        } else if (n == n3 || n == -1 && n3 == n2 || n == n2 && n3 == -1) {
            bl5 = true;
        }
        if (string6 == null || string6.equals(string3)) {
            bl3 = true;
        }
        if (string5.equals("*")) {
            bl4 = false;
        } else if (bl && string5.startsWith("*.")) {
            String string8 = string5.substring(2);
            if (string2.toLowerCase().endsWith(string8.toLowerCase())) {
                bl4 = true;
            }
        } else if (string5.equalsIgnoreCase(string2)) {
            bl4 = true;
        }
        bl6 = bl2 ? RuleId.pathIncludes(string7, string4, string3, string2) : string7 == null || string7.length() == 0 || string7.equals(string4);
        return bl3 && bl4 && bl5 && bl6;
    }

    private static boolean pathIncludes(String string, String string2, String string3, String string4) {
        boolean bl = false;
        int n = string2.indexOf(37);
        if (n >= 0 && (string2.indexOf("%2E", n) >= 0 || string2.indexOf("%2e", n) >= 0 || string2.indexOf("%2F", n) >= 0 || string2.indexOf("%2f", n) >= 0)) {
            throw new SecurityException("Unsupported encoded character in path");
        }
        String string5 = URLUtil.decodePath(string2);
        for (int i = 0; i < string5.length(); ++i) {
            char c = string5.charAt(i);
            if (c > '\u001f' && c != '\u007f' && c != '?' && c != '%' && c != '\\' && c != '#') continue;
            throw new SecurityException("Unsupported character in decoded path");
        }
        try {
            string2 = new URI(string3, string4, string5, null).normalize().getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SecurityException("unexpected excpetion", uRISyntaxException);
        }
        if (string == null || string.length() == 0 || string2.startsWith(string)) {
            bl = true;
        } else {
            Trace.println("Path mistach, actualPath: " + string2, TraceLevel.RULESET);
        }
        return bl;
    }

    protected boolean isException() {
        try {
            URL uRL;
            URL uRL2 = this.htmlLocation != null ? new URL(this.htmlLocation) : null;
            URL uRL3 = this.jnlpLocation != null ? new URL(this.jnlpLocation) : null;
            URL uRL4 = uRL = this.jarLocation != null ? new URL(this.jarLocation) : null;
            if (this.exceptionSites == null) {
                this.exceptionSites = Config.getExceptionSites();
            }
            if (uRL2 != null && this.onExceptionList(uRL2)) {
                if (uRL3 != null && !URLUtil.sameBase(uRL2, uRL3) && !this.onExceptionList(uRL3)) {
                    String string = ResourceManager.getString("deployment.blocked.exception.list.domains", "html", this.htmlLocation, "jnlp", this.jnlpLocation);
                    Trace.println(string, TraceLevel.BASIC);
                    throw new BlockedException(string, new Exception());
                }
                if (uRL != null && !URLUtil.sameBase(uRL2, uRL) && !this.onExceptionList(uRL)) {
                    String string = ResourceManager.getString("deployment.blocked.exception.list.domains", "html", this.htmlLocation, "jar", this.jarLocation);
                    Trace.println(string, TraceLevel.BASIC);
                    throw new BlockedException(string, new Exception());
                }
                return true;
            }
            if (uRL2 == null && uRL3 != null && this.onExceptionList(uRL3)) {
                if (uRL != null && !URLUtil.sameBase(uRL3, uRL) && !this.onExceptionList(uRL)) {
                    String string = ResourceManager.getString("deployment.blocked.exception.list.domains", "jnlp", this.jnlpLocation, "jar", this.jarLocation);
                    Trace.println(string, TraceLevel.BASIC);
                    throw new BlockedException(string, new Exception());
                }
                return true;
            }
            if (uRL2 == null && uRL3 == null) {
                if (this.anchorURL != null && this.onExceptionList(this.anchorURL)) {
                    if (uRL != null && !URLUtil.sameBase(this.anchorURL, uRL) && !this.onExceptionList(uRL)) {
                        String string = ResourceManager.getString("deployment.blocked.exception.list.domains", "jar", this.anchorURL.toString(), "jar", this.jarLocation);
                        Trace.println(string, TraceLevel.BASIC);
                        throw new BlockedException(string, new Exception());
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (IOException iOException) {
            Trace.println("IOException processing exception list: " + iOException, TraceLevel.RULESET);
            Trace.ignored(iOException);
            return false;
        }
    }

    private boolean onExceptionList(URL uRL) throws IOException {
        for (int i = 0; i < this.exceptionSites.length; ++i) {
            boolean bl;
            if (this.exceptionSites[i] == null || this.exceptionSites[i].length() <= 0 || !RuleId.compareStringToURL(this.exceptionSites[i], uRL, false, bl = this.exceptionSites[i].endsWith("/"))) continue;
            return true;
        }
        return false;
    }

    public String getLocation() {
        return this.location;
    }
}

