/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.Environment;
import com.sun.deploy.security.SecureStaticVersioning;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class DeploymentHooks {
    static boolean usageTrackerFailed = false;
    Object usageTracker;
    Method runMethod;
    String storedAppName = null;
    String storedArg1 = null;
    String storedArg2 = null;
    static /* synthetic */ Class class$java$lang$String;

    private boolean initialize() {
        if (usageTrackerFailed) {
            return false;
        }
        if (this.runMethod == null) {
            try {
                Class<?> clazz = Class.forName("sun.usagetracker.UsageTrackerClient", true, null);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                this.usageTracker = constructor.newInstance(new Object[0]);
                this.runMethod = clazz.getMethod("run", class$java$lang$String == null ? (class$java$lang$String = DeploymentHooks.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = DeploymentHooks.class$("java.lang.String")) : class$java$lang$String);
            }
            catch (Throwable throwable) {
                usageTrackerFailed = true;
                return false;
            }
        }
        return true;
    }

    public synchronized void storeAppName(String string) {
        this.storedAppName = string;
    }

    private synchronized String getAndClearAppName() {
        String string = this.storedAppName;
        this.storedAppName = null;
        return string;
    }

    public synchronized void trackUsage(AppInfo appInfo, DeploymentRuleSet deploymentRuleSet) {
        if (!this.initialize()) {
            return;
        }
        String string = this.getAndClearAppName();
        if (string == null) {
            return;
        }
        try {
            String string2 = null;
            if (Environment.isOldPlugin()) {
                string2 = "plugin";
            } else if (Environment.isJavaPlugin()) {
                string2 = Environment.isJavawsAppletLifecycle() ? "javaws applet" : "plugin2";
            } else if (Environment.isJavaWebStart()) {
                string2 = "javaws application";
            }
            if (deploymentRuleSet.isRuleBlock()) {
                string2 = string2 + " denied";
                if (deploymentRuleSet.getBlockString() != null) {
                    string2 = string2 + " [" + deploymentRuleSet.getBlockString() + "]";
                }
            } else if (deploymentRuleSet.isRuleRun()) {
                String string3 = deploymentRuleSet.getVersionString();
                string2 = string3 == null || SecureStaticVersioning.satisfiesDRSVersion(string3) ? string2 + " permitted" : string2 + " denied [required version " + string3 + " not available]";
            }
            this.storedArg1 = string2;
            this.storedArg2 = string;
        }
        catch (Throwable throwable) {
            Trace.println("Error invoking UsageTracker:", TraceLevel.BASIC);
            Trace.ignored(throwable);
        }
    }

    public synchronized void confirmAppRun() {
        this.confirm(this.storedArg1, this.storedArg2);
        this.storedArg2 = null;
        this.storedArg1 = null;
    }

    public synchronized void confirmAppDenied(DeploymentRuleSet deploymentRuleSet) {
        this.confirm(this.storedArg1 + " denied [by user]", this.storedArg2);
        this.storedArg2 = null;
        this.storedArg1 = null;
    }

    public synchronized void confirmAppBlocked(DeploymentRuleSet deploymentRuleSet) {
        String string = this.storedArg1;
        if (!deploymentRuleSet.isRuleBlock() && !deploymentRuleSet.isRuleRun()) {
            string = string + " denied [by security settings]";
        }
        this.confirm(string, this.storedArg2);
        this.storedArg2 = null;
        this.storedArg1 = null;
    }

    private void confirm(String string, String string2) {
        try {
            if (string != null && string2 != null) {
                Object[] objectArray = new Object[]{string, string2};
                this.runMethod.invoke(this.usageTracker, objectArray);
                Trace.println("JUT Record:\n    " + string + "\n    " + string2, TraceLevel.SECURITY);
            }
        }
        catch (Throwable throwable) {
            Trace.println("Error invoking UsageTracker:", TraceLevel.BASIC);
            Trace.ignored(throwable);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

