/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orbutil;

import com.sun.corba.se.impl.corba.CORBAObjectImpl;
import com.sun.corba.se.impl.ior.iiop.JavaSerializationComponent;
import com.sun.corba.se.impl.logging.OMGSystemException;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.pept.transport.ContactInfoList;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.iiop.IIOPProfile;
import com.sun.corba.se.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.orb.ORBVersionFactory;
import com.sun.corba.se.spi.presentation.rmi.StubAdapter;
import com.sun.corba.se.spi.protocol.CorbaClientDelegate;
import com.sun.corba.se.spi.protocol.CorbaMessageMediator;
import com.sun.corba.se.spi.transport.CorbaContactInfoList;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import javax.rmi.CORBA.ValueHandlerMultiFormat;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import sun.corba.SharedSecrets;

public final class ORBUtility {
    private static ORBUtilSystemException wrapper = ORBUtilSystemException.get("util");
    private static OMGSystemException omgWrapper = OMGSystemException.get("util");
    private static StructMember[] members = null;
    private static final Hashtable exceptionClassNames = new Hashtable();
    private static final Hashtable exceptionRepositoryIds = new Hashtable();

    private ORBUtility() {
    }

    private static StructMember[] systemExceptionMembers(ORB oRB) {
        if (members == null) {
            members = new StructMember[3];
            ORBUtility.members[0] = new StructMember("id", oRB.create_string_tc(0), null);
            ORBUtility.members[1] = new StructMember("minor", oRB.get_primitive_tc(TCKind.tk_long), null);
            ORBUtility.members[2] = new StructMember("completed", oRB.get_primitive_tc(TCKind.tk_long), null);
        }
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TypeCode getSystemExceptionTypeCode(ORB oRB, String string, String string2) {
        Class<TypeCode> clazz = TypeCode.class;
        synchronized (TypeCode.class) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return oRB.create_exception_tc(string, string2, ORBUtility.systemExceptionMembers(oRB));
        }
    }

    private static boolean isSystemExceptionTypeCode(TypeCode typeCode, ORB oRB) {
        StructMember[] structMemberArray = ORBUtility.systemExceptionMembers(oRB);
        try {
            return typeCode.kind().value() == 22 && typeCode.member_count() == 3 && typeCode.member_type(0).equal(structMemberArray[0].type) && typeCode.member_type(1).equal(structMemberArray[1].type) && typeCode.member_type(2).equal(structMemberArray[2].type);
        }
        catch (BadKind badKind) {
            return false;
        }
        catch (Bounds bounds) {
            return false;
        }
    }

    public static void insertSystemException(SystemException systemException, Any any) {
        OutputStream outputStream = any.create_output_stream();
        ORB oRB = (ORB)outputStream.orb();
        String string = systemException.getClass().getName();
        String string2 = ORBUtility.repositoryIdOf(string);
        outputStream.write_string(string2);
        outputStream.write_long(systemException.minor);
        outputStream.write_long(systemException.completed.value());
        any.read_value(outputStream.create_input_stream(), ORBUtility.getSystemExceptionTypeCode(oRB, string2, string));
    }

    public static SystemException extractSystemException(Any any) {
        InputStream inputStream = any.create_input_stream();
        ORB oRB = (ORB)inputStream.orb();
        if (!ORBUtility.isSystemExceptionTypeCode(any.type(), oRB)) {
            throw wrapper.unknownDsiSysex(CompletionStatus.COMPLETED_MAYBE);
        }
        return ORBUtility.readSystemException(inputStream);
    }

    public static ValueHandler createValueHandler() {
        ValueHandler valueHandler;
        try {
            valueHandler = AccessController.doPrivileged(new PrivilegedExceptionAction<ValueHandler>(){

                @Override
                public ValueHandler run() throws Exception {
                    return Util.createValueHandler();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            privilegedActionException.printStackTrace();
            throw new InternalError(privilegedActionException.getCause().toString());
        }
        return valueHandler;
    }

    public static boolean isForeignORB(ORB oRB) {
        if (oRB == null) {
            return false;
        }
        try {
            return oRB.getORBVersion().equals(ORBVersionFactory.getFOREIGN());
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static int bytesToInt(byte[] byArray, int n) {
        int n2 = byArray[n++] << 24 & 0xFF000000;
        int n3 = byArray[n++] << 16 & 0xFF0000;
        int n4 = byArray[n++] << 8 & 0xFF00;
        int n5 = byArray[n++] << 0 & 0xFF;
        return n2 | n3 | n4 | n5;
    }

    public static void intToBytes(int n, byte[] byArray, int n2) {
        byArray[n2++] = (byte)(n >>> 24 & 0xFF);
        byArray[n2++] = (byte)(n >>> 16 & 0xFF);
        byArray[n2++] = (byte)(n >>> 8 & 0xFF);
        byArray[n2++] = (byte)(n >>> 0 & 0xFF);
    }

    public static int hexOf(char c) {
        int n = c - 48;
        if (n >= 0 && n <= 9) {
            return n;
        }
        n = c - 97 + 10;
        if (n >= 10 && n <= 15) {
            return n;
        }
        n = c - 65 + 10;
        if (n >= 10 && n <= 15) {
            return n;
        }
        throw wrapper.badHexDigit();
    }

    public static void writeSystemException(SystemException systemException, OutputStream outputStream) {
        String string = ORBUtility.repositoryIdOf(systemException.getClass().getName());
        outputStream.write_string(string);
        outputStream.write_long(systemException.minor);
        outputStream.write_long(systemException.completed.value());
    }

    public static SystemException readSystemException(InputStream inputStream) {
        try {
            String string = ORBUtility.classNameOf(inputStream.read_string());
            SystemException systemException = (SystemException)SharedSecrets.getJavaCorbaAccess().loadClass(string).newInstance();
            systemException.minor = inputStream.read_long();
            systemException.completed = CompletionStatus.from_int(inputStream.read_long());
            return systemException;
        }
        catch (Exception exception) {
            throw wrapper.unknownSysex(CompletionStatus.COMPLETED_MAYBE, exception);
        }
    }

    public static String classNameOf(String string) {
        String string2 = null;
        string2 = (String)exceptionClassNames.get(string);
        if (string2 == null) {
            string2 = "org.omg.CORBA.UNKNOWN";
        }
        return string2;
    }

    public static boolean isSystemException(String string) {
        String string2 = null;
        string2 = (String)exceptionClassNames.get(string);
        return string2 != null;
    }

    public static byte getEncodingVersion(ORB oRB, IOR iOR) {
        IIOPProfile iIOPProfile;
        IIOPProfileTemplate iIOPProfileTemplate;
        Iterator iterator;
        if (oRB.getORBData().isJavaSerializationEnabled() && (iterator = (iIOPProfileTemplate = (IIOPProfileTemplate)(iIOPProfile = iOR.getProfile()).getTaggedProfileTemplate()).iteratorById(1398099458)).hasNext()) {
            JavaSerializationComponent javaSerializationComponent = (JavaSerializationComponent)iterator.next();
            byte by = javaSerializationComponent.javaSerializationVersion();
            if (by >= 1) {
                return 1;
            }
            if (by > 0) {
                return javaSerializationComponent.javaSerializationVersion();
            }
        }
        return 0;
    }

    public static String repositoryIdOf(String string) {
        String string2 = (String)exceptionRepositoryIds.get(string);
        if (string2 == null) {
            string2 = "IDL:omg.org/CORBA/UNKNOWN:1.0";
        }
        return string2;
    }

    public static int[] parseVersion(String string) {
        int n;
        int n2;
        if (string == null) {
            return new int[0];
        }
        char[] cArray = string.toCharArray();
        for (n2 = 0; n2 < cArray.length && (cArray[n2] < '0' || cArray[n2] > '9'); ++n2) {
            if (n2 != cArray.length) continue;
            return new int[0];
        }
        int n3 = 1;
        for (n = n2 + 1; n < cArray.length; ++n) {
            if (cArray[n] == '.') {
                ++n3;
                continue;
            }
            if (cArray[n] < '0' || cArray[n] > '9') break;
        }
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            int n4 = string.indexOf(46, n2);
            if (n4 == -1 || n4 > n) {
                n4 = n;
            }
            nArray[i] = n2 >= n4 ? 0 : Integer.parseInt(string.substring(n2, n4));
            n2 = n4 + 1;
        }
        return nArray;
    }

    public static int compareVersion(int[] nArray, int[] nArray2) {
        if (nArray == null) {
            nArray = new int[]{};
        }
        if (nArray2 == null) {
            nArray2 = new int[]{};
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (i >= nArray2.length || nArray[i] > nArray2[i]) {
                return 1;
            }
            if (nArray[i] >= nArray2[i]) continue;
            return -1;
        }
        return nArray.length == nArray2.length ? 0 : -1;
    }

    public static synchronized int compareVersion(String string, String string2) {
        return ORBUtility.compareVersion(ORBUtility.parseVersion(string), ORBUtility.parseVersion(string2));
    }

    private static String compressClassName(String string) {
        String string2 = "com.sun.corba.se.";
        if (string.startsWith(string2)) {
            return "(ORB)." + string.substring(string2.length());
        }
        return string;
    }

    public static String getThreadName(Thread thread) {
        if (thread == null) {
            return "null";
        }
        String string = thread.getName();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        if (n != 5) {
            return string;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        if (!stringArray[0].equals("SelectReaderThread")) {
            return string;
        }
        return "SelectReaderThread[" + stringArray[2] + ":" + stringArray[3] + "]";
    }

    private static String formatStackTraceElement(StackTraceElement stackTraceElement) {
        return ORBUtility.compressClassName(stackTraceElement.getClassName()) + "." + stackTraceElement.getMethodName() + (stackTraceElement.isNativeMethod() ? "(Native Method)" : (stackTraceElement.getFileName() != null && stackTraceElement.getLineNumber() >= 0 ? "(" + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ")" : (stackTraceElement.getFileName() != null ? "(" + stackTraceElement.getFileName() + ")" : "(Unknown Source)")));
    }

    private static void printStackTrace(StackTraceElement[] stackTraceElementArray) {
        System.out.println("    Stack Trace:");
        for (int i = 1; i < stackTraceElementArray.length; ++i) {
            System.out.print("        >");
            System.out.println(ORBUtility.formatStackTraceElement(stackTraceElementArray[i]));
        }
    }

    public static synchronized void dprint(java.lang.Object object, String string) {
        System.out.println(ORBUtility.compressClassName(object.getClass().getName()) + "(" + ORBUtility.getThreadName(Thread.currentThread()) + "): " + string);
    }

    public static synchronized void dprint(String string, String string2) {
        System.out.println(ORBUtility.compressClassName(string) + "(" + ORBUtility.getThreadName(Thread.currentThread()) + "): " + string2);
    }

    public synchronized void dprint(String string) {
        ORBUtility.dprint(this, string);
    }

    public static synchronized void dprintTrace(java.lang.Object object, String string) {
        ORBUtility.dprint(object, string);
        Throwable throwable = new Throwable();
        ORBUtility.printStackTrace(throwable.getStackTrace());
    }

    public static synchronized void dprint(java.lang.Object object, String string, Throwable throwable) {
        System.out.println(ORBUtility.compressClassName(object.getClass().getName()) + '(' + Thread.currentThread() + "): " + string);
        if (throwable != null) {
            ORBUtility.printStackTrace(throwable.getStackTrace());
        }
    }

    public static String[] concatenateStringArrays(String[] stringArray, String[] stringArray2) {
        int n;
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray3[n] = stringArray[n];
        }
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray3[n + stringArray.length] = stringArray2[n];
        }
        return stringArray3;
    }

    public static void throwNotSerializableForCorba(String string) {
        throw omgWrapper.notSerializable(CompletionStatus.COMPLETED_MAYBE, (java.lang.Object)string);
    }

    public static byte getMaxStreamFormatVersion() {
        ValueHandler valueHandler;
        try {
            valueHandler = AccessController.doPrivileged(new PrivilegedExceptionAction<ValueHandler>(){

                @Override
                public ValueHandler run() throws Exception {
                    return Util.createValueHandler();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            privilegedActionException.printStackTrace();
            throw new InternalError(privilegedActionException.getCause().toString());
        }
        if (!(valueHandler instanceof ValueHandlerMultiFormat)) {
            return 1;
        }
        return ((ValueHandlerMultiFormat)valueHandler).getMaximumStreamFormatVersion();
    }

    public static CorbaClientDelegate makeClientDelegate(IOR iOR) {
        ORB oRB = iOR.getORB();
        CorbaContactInfoList corbaContactInfoList = oRB.getCorbaContactInfoListFactory().create(iOR);
        CorbaClientDelegate corbaClientDelegate = oRB.getClientDelegateFactory().create(corbaContactInfoList);
        return corbaClientDelegate;
    }

    public static Object makeObjectReference(IOR iOR) {
        CorbaClientDelegate corbaClientDelegate = ORBUtility.makeClientDelegate(iOR);
        CORBAObjectImpl cORBAObjectImpl = new CORBAObjectImpl();
        StubAdapter.setDelegate(cORBAObjectImpl, corbaClientDelegate);
        return cORBAObjectImpl;
    }

    public static IOR getIOR(Object object) {
        if (object == null) {
            throw wrapper.nullObjectReference();
        }
        IOR iOR = null;
        if (StubAdapter.isStub(object)) {
            Delegate delegate = StubAdapter.getDelegate(object);
            if (delegate instanceof CorbaClientDelegate) {
                CorbaClientDelegate corbaClientDelegate = (CorbaClientDelegate)delegate;
                ContactInfoList contactInfoList = corbaClientDelegate.getContactInfoList();
                if (contactInfoList instanceof CorbaContactInfoList) {
                    CorbaContactInfoList corbaContactInfoList = (CorbaContactInfoList)contactInfoList;
                    iOR = corbaContactInfoList.getTargetIOR();
                    if (iOR == null) {
                        throw wrapper.nullIor();
                    }
                    return iOR;
                }
                throw new INTERNAL();
            }
            throw wrapper.objrefFromForeignOrb();
        }
        throw wrapper.localObjectNotAllowed();
    }

    public static IOR connectAndGetIOR(ORB oRB, Object object) {
        IOR iOR;
        try {
            iOR = ORBUtility.getIOR(object);
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            if (StubAdapter.isStub(object)) {
                try {
                    StubAdapter.connect(object, oRB);
                }
                catch (RemoteException remoteException) {
                    throw wrapper.connectingServant(remoteException);
                }
            } else {
                oRB.connect(object);
            }
            iOR = ORBUtility.getIOR(object);
        }
        return iOR;
    }

    public static String operationNameAndRequestId(CorbaMessageMediator corbaMessageMediator) {
        return "op/" + corbaMessageMediator.getOperationName() + " id/" + corbaMessageMediator.getRequestId();
    }

    public static boolean isPrintable(char c) {
        if (Character.isJavaIdentifierStart(c)) {
            return true;
        }
        if (Character.isDigit(c)) {
            return true;
        }
        switch (Character.getType(c)) {
            case 27: {
                return true;
            }
            case 20: {
                return true;
            }
            case 25: {
                return true;
            }
            case 24: {
                return true;
            }
            case 21: {
                return true;
            }
            case 22: {
                return true;
            }
        }
        return false;
    }

    public static String getClassSecurityInfo(final Class clazz) {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public java.lang.Object run() {
                StringBuffer stringBuffer = new StringBuffer(500);
                ProtectionDomain protectionDomain = clazz.getProtectionDomain();
                Policy policy = Policy.getPolicy();
                PermissionCollection permissionCollection = policy.getPermissions(protectionDomain);
                stringBuffer.append("\nPermissionCollection ");
                stringBuffer.append(permissionCollection.toString());
                stringBuffer.append(protectionDomain.toString());
                return stringBuffer.toString();
            }
        });
        return string;
    }

    static {
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_CONTEXT:1.0", "org.omg.CORBA.BAD_CONTEXT");
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_INV_ORDER:1.0", "org.omg.CORBA.BAD_INV_ORDER");
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_OPERATION:1.0", "org.omg.CORBA.BAD_OPERATION");
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_PARAM:1.0", "org.omg.CORBA.BAD_PARAM");
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_TYPECODE:1.0", "org.omg.CORBA.BAD_TYPECODE");
        exceptionClassNames.put("IDL:omg.org/CORBA/COMM_FAILURE:1.0", "org.omg.CORBA.COMM_FAILURE");
        exceptionClassNames.put("IDL:omg.org/CORBA/DATA_CONVERSION:1.0", "org.omg.CORBA.DATA_CONVERSION");
        exceptionClassNames.put("IDL:omg.org/CORBA/IMP_LIMIT:1.0", "org.omg.CORBA.IMP_LIMIT");
        exceptionClassNames.put("IDL:omg.org/CORBA/INTF_REPOS:1.0", "org.omg.CORBA.INTF_REPOS");
        exceptionClassNames.put("IDL:omg.org/CORBA/INTERNAL:1.0", "org.omg.CORBA.INTERNAL");
        exceptionClassNames.put("IDL:omg.org/CORBA/INV_FLAG:1.0", "org.omg.CORBA.INV_FLAG");
        exceptionClassNames.put("IDL:omg.org/CORBA/INV_IDENT:1.0", "org.omg.CORBA.INV_IDENT");
        exceptionClassNames.put("IDL:omg.org/CORBA/INV_OBJREF:1.0", "org.omg.CORBA.INV_OBJREF");
        exceptionClassNames.put("IDL:omg.org/CORBA/MARSHAL:1.0", "org.omg.CORBA.MARSHAL");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_MEMORY:1.0", "org.omg.CORBA.NO_MEMORY");
        exceptionClassNames.put("IDL:omg.org/CORBA/FREE_MEM:1.0", "org.omg.CORBA.FREE_MEM");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_IMPLEMENT:1.0", "org.omg.CORBA.NO_IMPLEMENT");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_PERMISSION:1.0", "org.omg.CORBA.NO_PERMISSION");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_RESOURCES:1.0", "org.omg.CORBA.NO_RESOURCES");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_RESPONSE:1.0", "org.omg.CORBA.NO_RESPONSE");
        exceptionClassNames.put("IDL:omg.org/CORBA/OBJ_ADAPTER:1.0", "org.omg.CORBA.OBJ_ADAPTER");
        exceptionClassNames.put("IDL:omg.org/CORBA/INITIALIZE:1.0", "org.omg.CORBA.INITIALIZE");
        exceptionClassNames.put("IDL:omg.org/CORBA/PERSIST_STORE:1.0", "org.omg.CORBA.PERSIST_STORE");
        exceptionClassNames.put("IDL:omg.org/CORBA/TRANSIENT:1.0", "org.omg.CORBA.TRANSIENT");
        exceptionClassNames.put("IDL:omg.org/CORBA/UNKNOWN:1.0", "org.omg.CORBA.UNKNOWN");
        exceptionClassNames.put("IDL:omg.org/CORBA/OBJECT_NOT_EXIST:1.0", "org.omg.CORBA.OBJECT_NOT_EXIST");
        exceptionClassNames.put("IDL:omg.org/CORBA/INVALID_TRANSACTION:1.0", "org.omg.CORBA.INVALID_TRANSACTION");
        exceptionClassNames.put("IDL:omg.org/CORBA/TRANSACTION_REQUIRED:1.0", "org.omg.CORBA.TRANSACTION_REQUIRED");
        exceptionClassNames.put("IDL:omg.org/CORBA/TRANSACTION_ROLLEDBACK:1.0", "org.omg.CORBA.TRANSACTION_ROLLEDBACK");
        exceptionClassNames.put("IDL:omg.org/CORBA/INV_POLICY:1.0", "org.omg.CORBA.INV_POLICY");
        exceptionClassNames.put("IDL:omg.org/CORBA/TRANSACTION_UNAVAILABLE:1.0", "org.omg.CORBA.TRANSACTION_UNAVAILABLE");
        exceptionClassNames.put("IDL:omg.org/CORBA/TRANSACTION_MODE:1.0", "org.omg.CORBA.TRANSACTION_MODE");
        exceptionClassNames.put("IDL:omg.org/CORBA/CODESET_INCOMPATIBLE:1.0", "org.omg.CORBA.CODESET_INCOMPATIBLE");
        exceptionClassNames.put("IDL:omg.org/CORBA/REBIND:1.0", "org.omg.CORBA.REBIND");
        exceptionClassNames.put("IDL:omg.org/CORBA/TIMEOUT:1.0", "org.omg.CORBA.TIMEOUT");
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_QOS:1.0", "org.omg.CORBA.BAD_QOS");
        exceptionClassNames.put("IDL:omg.org/CORBA/INVALID_ACTIVITY:1.0", "org.omg.CORBA.INVALID_ACTIVITY");
        exceptionClassNames.put("IDL:omg.org/CORBA/ACTIVITY_COMPLETED:1.0", "org.omg.CORBA.ACTIVITY_COMPLETED");
        exceptionClassNames.put("IDL:omg.org/CORBA/ACTIVITY_REQUIRED:1.0", "org.omg.CORBA.ACTIVITY_REQUIRED");
        Enumeration enumeration = exceptionClassNames.keys();
        try {
            while (enumeration.hasMoreElements()) {
                java.lang.Object k = enumeration.nextElement();
                String string = (String)k;
                String string2 = (String)exceptionClassNames.get(string);
                exceptionRepositoryIds.put(string2, string);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }
}

